/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.plugins.xml.FileUtils;
import org.sonar.plugins.xml.compat.CompatibleInputFile;

public class XmlFile {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFile.class);
    private static final String XML_PROLOG_START_TAG = "<?xml";
    public static final String BOM_CHAR = "\ufeff";
    private final CompatibleInputFile inputFile;
    private File noCharBeforePrologFile;
    private int lineDeltaForIssue = 0;
    private int characterDeltaForHighlight = 0;
    private boolean hasCharsBeforeProlog = false;

    public XmlFile(CompatibleInputFile inputFile, FileSystem fileSystem) {
        this.inputFile = inputFile;
        this.checkForCharactersBeforeProlog(fileSystem);
    }

    public String getFilePath() {
        return this.inputFile.absolutePath();
    }

    private void checkForCharactersBeforeProlog(FileSystem fileSystem) {
        try {
            int lineNb = 1;
            Pattern firstTagPattern = Pattern.compile("<[a-zA-Z?]+");
            boolean hasBOM = false;
            for (String line : FileUtils.readLines(this.inputFile)) {
                Matcher m;
                if (lineNb == 1 && line.startsWith(BOM_CHAR)) {
                    hasBOM = true;
                    this.characterDeltaForHighlight = -1;
                }
                if ((m = firstTagPattern.matcher(line)).find()) {
                    int column = line.indexOf(m.group());
                    if (!XML_PROLOG_START_TAG.equals(m.group()) || XmlFile.isFileBeginning(lineNb, column, hasBOM)) break;
                    this.hasCharsBeforeProlog = true;
                    break;
                }
                ++lineNb;
            }
            if (this.hasCharsBeforeProlog) {
                this.processCharBeforePrologInFile(fileSystem, lineNb);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to analyse file {}", (Object)this.inputFile.absolutePath(), (Object)e);
        }
    }

    private static boolean isFileBeginning(int line, int column, boolean hasBOM) {
        return line == 1 && column <= (hasBOM ? 1 : 0);
    }

    private void processCharBeforePrologInFile(FileSystem fileSystem, int lineDelta) {
        try {
            String content = this.inputFile.contents();
            File tempFile = new File(fileSystem.workDir(), this.inputFile.fileName());
            int index = content.indexOf(XML_PROLOG_START_TAG);
            com.google.common.io.Files.write((CharSequence)content.substring(index), (File)tempFile, (Charset)this.inputFile.charset());
            this.noCharBeforePrologFile = tempFile;
            if (index != -1) {
                this.characterDeltaForHighlight += index;
            }
            if (lineDelta > 1) {
                this.lineDeltaForIssue = lineDelta - 1;
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to analyse file {}", (Object)this.inputFile.absolutePath(), (Object)e);
        }
    }

    public CompatibleInputFile getInputFile() {
        return this.inputFile;
    }

    public int getLineDelta() {
        return this.lineDeltaForIssue;
    }

    public int getOffsetDelta() {
        return this.characterDeltaForHighlight;
    }

    public InputStream getInputStream() throws IOException {
        if (this.noCharBeforePrologFile == null) {
            return this.inputFile.inputStream();
        }
        return Files.newInputStream(this.noCharBeforePrologFile.toPath(), new OpenOption[0]);
    }

    public String getContents() throws IOException {
        if (this.noCharBeforePrologFile == null) {
            return this.inputFile.contents();
        }
        return FileUtils.contents(this.noCharBeforePrologFile.toPath(), this.inputFile.charset());
    }

    public int getPrologLine() {
        return this.lineDeltaForIssue + 1;
    }

    public boolean hasCharsBeforeProlog() {
        return this.hasCharsBeforeProlog;
    }

    public String getAbsolutePath() {
        return this.inputFile.absolutePath();
    }

    public Charset getCharset() {
        return this.inputFile.charset();
    }
}

