/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.plugins.xml.checks.XmlIssue;
import org.sonar.plugins.xml.checks.XmlSourceCode;

public abstract class AbstractXmlCheck {
    private RuleKey ruleKey;
    private XmlSourceCode xmlSourceCode;

    protected final void createViolation(Integer linePosition, String message) {
        this.getWebSourceCode().addViolation(new XmlIssue(this.ruleKey, linePosition, message));
    }

    protected XmlSourceCode getWebSourceCode() {
        return this.xmlSourceCode;
    }

    protected boolean isFileIncluded(@Nullable String filePattern) {
        if (filePattern != null) {
            return WildcardPattern.create((String)filePattern).match(this.getWebSourceCode().getLogicalPath());
        }
        return true;
    }

    public final void setRuleKey(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
    }

    public RuleKey getRuleKey() {
        return this.ruleKey;
    }

    protected void setWebSourceCode(XmlSourceCode xmlSourceCode) {
        this.xmlSourceCode = xmlSourceCode;
    }

    public abstract void validate(XmlSourceCode var1);
}

