/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml;

import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.xml.LineCountData;
import org.sonar.plugins.xml.checks.XmlFile;
import org.sonar.plugins.xml.compat.CompatibleInputFile;
import org.sonar.plugins.xml.parsers.LineCountParser;
import org.sonar.plugins.xml.parsers.ParseException;
import org.xml.sax.SAXException;

public final class LineCounter {
    private static final Logger LOG = LoggerFactory.getLogger(LineCounter.class);

    private LineCounter() {
    }

    private static void saveMeasures(XmlFile xmlFile, LineCountData data, FileLinesContext fileLinesContext, SensorContext context) {
        data.updateAccordingTo(xmlFile.getLineDelta());
        for (int line = 1; line <= data.linesNumber(); ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, data.linesOfCodeLines().contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("comment_lines_data", line, data.effectiveCommentLines().contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
        LineCounter.saveMeasure(context, xmlFile.getInputFile(), CoreMetrics.COMMENT_LINES, data.effectiveCommentLines().size());
        LineCounter.saveMeasure(context, xmlFile.getInputFile(), CoreMetrics.NCLOC, data.linesOfCodeLines().size());
    }

    private static <T extends Serializable> void saveMeasure(SensorContext context, CompatibleInputFile inputFile, Metric<T> metric, T value) {
        context.newMeasure().withValue(value).forMetric(metric).on((InputComponent)inputFile.wrapped()).save();
    }

    public static void analyse(SensorContext context, FileLinesContextFactory fileLinesContextFactory, XmlFile xmlFile) {
        LOG.debug("Count lines in " + xmlFile.getAbsolutePath());
        try {
            LineCounter.saveMeasures(xmlFile, new LineCountParser(xmlFile.getContents(), xmlFile.getCharset()).getLineCountData(), fileLinesContextFactory.createFor(xmlFile.getInputFile().wrapped()), context);
        }
        catch (IOException | SAXException e) {
            LOG.debug("Unable to count lines for file " + xmlFile.getAbsolutePath());
            throw new ParseException(e);
        }
    }
}

