/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.measures.Metric;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.AnalysisPropertyDto;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.server.project.Project;
import org.sonar.server.qualitygate.EvaluatedQualityGate;
import org.sonar.server.qualitygate.changeevent.QGChangeEvent;
import org.sonar.server.qualitygate.changeevent.QGChangeEventListener;
import org.sonar.server.webhook.Analysis;
import org.sonar.server.webhook.Branch;
import org.sonar.server.webhook.ProjectAnalysis;
import org.sonar.server.webhook.WebHooks;
import org.sonar.server.webhook.WebhookPayload;
import org.sonar.server.webhook.WebhookPayloadFactory;

public class WebhookQGChangeEventListener
implements QGChangeEventListener {
    private final WebHooks webhooks;
    private final WebhookPayloadFactory webhookPayloadFactory;
    private final DbClient dbClient;

    public WebhookQGChangeEventListener(WebHooks webhooks, WebhookPayloadFactory webhookPayloadFactory, DbClient dbClient) {
        this.webhooks = webhooks;
        this.webhookPayloadFactory = webhookPayloadFactory;
        this.dbClient = dbClient;
    }

    @Override
    public void onIssueChanges(QGChangeEvent qualityGateEvent, Set<QGChangeEventListener.ChangedIssue> changedIssues) {
        if (!this.webhooks.isEnabled(qualityGateEvent.getProject())) {
            return;
        }
        Optional<EvaluatedQualityGate> evaluatedQualityGate = qualityGateEvent.getQualityGateSupplier().get();
        if (WebhookQGChangeEventListener.isQGStatusUnchanged(qualityGateEvent, evaluatedQualityGate)) {
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.callWebhook(dbSession, qualityGateEvent, evaluatedQualityGate.orElse(null));
        }
    }

    private static boolean isQGStatusUnchanged(QGChangeEvent qualityGateEvent, Optional<EvaluatedQualityGate> evaluatedQualityGate) {
        Optional<Metric.Level> previousStatus = qualityGateEvent.getPreviousStatus();
        if (!previousStatus.isPresent() && !evaluatedQualityGate.isPresent()) {
            return true;
        }
        return previousStatus.map(previousQGStatus -> evaluatedQualityGate.filter(newQualityGate -> newQualityGate.getStatus() == previousQGStatus).isPresent()).orElse(false);
    }

    private void callWebhook(DbSession dbSession, QGChangeEvent event, @Nullable EvaluatedQualityGate evaluatedQualityGate) {
        this.webhooks.sendProjectAnalysisUpdate(new WebHooks.Analysis(event.getBranch().getUuid(), event.getAnalysis().getUuid(), null), () -> this.buildWebHookPayload(dbSession, event, evaluatedQualityGate));
    }

    private WebhookPayload buildWebHookPayload(DbSession dbSession, QGChangeEvent event, @Nullable EvaluatedQualityGate evaluatedQualityGate) {
        ComponentDto project = event.getProject();
        BranchDto branch = event.getBranch();
        SnapshotDto analysis = event.getAnalysis();
        Map<String, String> analysisProperties = this.dbClient.analysisPropertiesDao().selectBySnapshotUuid(dbSession, analysis.getUuid()).stream().collect(Collectors.toMap(AnalysisPropertyDto::getKey, AnalysisPropertyDto::getValue));
        String projectUuid = StringUtils.defaultString((String)project.getMainBranchProjectUuid(), (String)project.projectUuid());
        ProjectAnalysis projectAnalysis = new ProjectAnalysis(new Project(projectUuid, project.getKey(), project.name()), null, new Analysis(analysis.getUuid(), analysis.getCreatedAt()), new Branch(branch.isMain(), branch.getKey(), Branch.Type.valueOf(branch.getBranchType().name())), evaluatedQualityGate, null, analysisProperties);
        return this.webhookPayloadFactory.create(projectAnalysis);
    }
}

