/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.project.Project;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.EvaluatedCondition;
import org.sonar.server.qualitygate.EvaluatedQualityGate;
import org.sonar.server.webhook.Branch;
import org.sonar.server.webhook.CeTask;
import org.sonar.server.webhook.ProjectAnalysis;
import org.sonar.server.webhook.WebhookPayload;
import org.sonar.server.webhook.WebhookPayloadFactory;

@ComputeEngineSide
public class WebhookPayloadFactoryImpl
implements WebhookPayloadFactory {
    private static final String PROPERTY_STATUS = "status";
    private final Server server;
    private final System2 system2;

    public WebhookPayloadFactoryImpl(Server server, System2 system2) {
        this.server = server;
        this.system2 = system2;
    }

    @Override
    public WebhookPayload create(ProjectAnalysis analysis) {
        StringWriter string = new StringWriter();
        try (JsonWriter writer = JsonWriter.of((Writer)string);){
            writer.beginObject();
            this.writeServer(writer);
            WebhookPayloadFactoryImpl.writeTask(writer, analysis.getCeTask());
            WebhookPayloadFactoryImpl.writeDates(writer, analysis, this.system2);
            this.writeProject(analysis, writer, analysis.getProject());
            analysis.getBranch().ifPresent(b -> this.writeBranch(writer, analysis.getProject(), (Branch)b));
            analysis.getQualityGate().ifPresent(qualityGate -> WebhookPayloadFactoryImpl.writeQualityGate(writer, qualityGate));
            WebhookPayloadFactoryImpl.writeAnalysisProperties(writer, analysis.getProperties());
            writer.endObject().close();
            WebhookPayload webhookPayload = new WebhookPayload(analysis.getProject().getKey(), ((Object)string).toString());
            return webhookPayload;
        }
    }

    private void writeServer(JsonWriter writer) {
        writer.prop("serverUrl", this.server.getPublicRootUrl());
    }

    private static void writeDates(JsonWriter writer, ProjectAnalysis analysis, System2 system2) {
        analysis.getAnalysis().ifPresent(a -> writer.propDateTime("analysedAt", a.getDate()));
        writer.propDateTime("changedAt", new Date(analysis.getUpdatedAt().orElse(system2.now())));
    }

    private void writeProject(ProjectAnalysis analysis, JsonWriter writer, Project project) {
        writer.name("project").beginObject().prop("key", project.getKey()).prop("name", analysis.getProject().getName()).prop("url", this.projectUrlOf(project)).endObject();
    }

    private static void writeAnalysisProperties(JsonWriter writer, Map<String, String> properties) {
        writer.name("properties").beginObject();
        properties.entrySet().stream().filter(prop -> ((String)prop.getKey()).startsWith("sonar.analysis.")).forEach(prop -> writer.prop((String)prop.getKey(), (String)prop.getValue()));
        writer.endObject();
    }

    private static void writeTask(JsonWriter writer, Optional<CeTask> ceTask) {
        ceTask.ifPresent(ceTask1 -> writer.prop("taskId", ceTask1.getId()));
        writer.prop(PROPERTY_STATUS, ceTask.map(CeTask::getStatus).orElse(CeTask.Status.SUCCESS).toString());
    }

    private void writeBranch(JsonWriter writer, Project project, Branch branch) {
        writer.name("branch").beginObject().prop("name", (String)branch.getName().orElse(null)).prop("type", branch.getType().name()).prop("isMain", branch.isMain()).prop("url", this.branchUrlOf(project, branch)).endObject();
    }

    private String projectUrlOf(Project project) {
        return String.format("%s/dashboard?id=%s", this.server.getPublicRootUrl(), WebhookPayloadFactoryImpl.encode(project.getKey()));
    }

    private String branchUrlOf(Project project, Branch branch) {
        if (branch.getType() == Branch.Type.LONG) {
            if (branch.isMain()) {
                return this.projectUrlOf(project);
            }
            return String.format("%s/dashboard?branch=%s&id=%s", this.server.getPublicRootUrl(), WebhookPayloadFactoryImpl.encode(branch.getName().orElse("")), WebhookPayloadFactoryImpl.encode(project.getKey()));
        }
        if (branch.getType() == Branch.Type.SHORT) {
            return String.format("%s/project/issues?branch=%s&id=%s&resolved=false", this.server.getPublicRootUrl(), WebhookPayloadFactoryImpl.encode(branch.getName().orElse("")), WebhookPayloadFactoryImpl.encode(project.getKey()));
        }
        if (branch.getType() == Branch.Type.PULL_REQUEST) {
            return String.format("%s/project/issues?pullRequest=%s&id=%s&resolved=false", this.server.getPublicRootUrl(), WebhookPayloadFactoryImpl.encode(branch.getName().orElse("")), WebhookPayloadFactoryImpl.encode(project.getKey()));
        }
        return this.projectUrlOf(project);
    }

    private static void writeQualityGate(JsonWriter writer, EvaluatedQualityGate gate) {
        writer.name("qualityGate").beginObject().prop("name", gate.getQualityGate().getName()).prop(PROPERTY_STATUS, gate.getStatus().toString()).name("conditions").beginArray();
        for (EvaluatedCondition evaluatedCondition : gate.getEvaluatedConditions()) {
            Condition condition = evaluatedCondition.getCondition();
            writer.beginObject().prop("metric", condition.getMetricKey()).prop("operator", condition.getOperator().name());
            evaluatedCondition.getValue().ifPresent(t -> writer.prop("value", t));
            writer.prop(PROPERTY_STATUS, evaluatedCondition.getStatus().name()).prop("onLeakPeriod", condition.isOnLeakPeriod()).prop("errorThreshold", (String)condition.getErrorThreshold().orElse(null)).prop("warningThreshold", (String)condition.getWarningThreshold().orElse(null)).endObject();
        }
        writer.endArray().endObject();
    }

    private static String encode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Encoding not supported", e);
        }
    }
}

