/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.webhook.WebhookDao;
import org.sonar.db.webhook.WebhookDto;
import org.sonar.server.async.AsyncExecution;
import org.sonar.server.webhook.WebHooks;
import org.sonar.server.webhook.Webhook;
import org.sonar.server.webhook.WebhookCaller;
import org.sonar.server.webhook.WebhookDelivery;
import org.sonar.server.webhook.WebhookDeliveryStorage;
import org.sonar.server.webhook.WebhookPayload;
import org.sonar.server.ws.WsUtils;

public class WebHooksImpl
implements WebHooks {
    private static final Logger LOGGER = Loggers.get(WebHooksImpl.class);
    private final WebhookCaller caller;
    private final WebhookDeliveryStorage deliveryStorage;
    private final AsyncExecution asyncExecution;
    private final DbClient dbClient;

    public WebHooksImpl(WebhookCaller caller, WebhookDeliveryStorage deliveryStorage, AsyncExecution asyncExecution, DbClient dbClient) {
        this.caller = caller;
        this.deliveryStorage = deliveryStorage;
        this.asyncExecution = asyncExecution;
        this.dbClient = dbClient;
    }

    @Override
    public boolean isEnabled(ComponentDto projectDto) {
        return this.readWebHooksFrom(projectDto.uuid()).findAny().isPresent();
    }

    private Stream<WebhookDto> readWebHooksFrom(String projectUuid) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional<Object> optionalComponentDto = Optional.ofNullable(this.dbClient.componentDao().selectByUuid(dbSession, projectUuid).orNull());
            ComponentDto componentDto = (ComponentDto)WsUtils.checkStateWithOptional(optionalComponentDto, "the requested project '%s' was not found", projectUuid);
            if (componentDto.getMainBranchProjectUuid() != null && !componentDto.uuid().equals(componentDto.getMainBranchProjectUuid())) {
                Optional<Object> mainBranchComponentDto = Optional.ofNullable(this.dbClient.componentDao().selectByUuid(dbSession, componentDto.getMainBranchProjectUuid()).orNull());
                componentDto = (ComponentDto)WsUtils.checkStateWithOptional(mainBranchComponentDto, "the requested project '%s' was not found", projectUuid);
            }
            WebhookDao dao = this.dbClient.webhookDao();
            Stream<WebhookDto> stream = Stream.concat(dao.selectByProject(dbSession, componentDto).stream(), dao.selectByOrganizationUuid(dbSession, componentDto.getOrganizationUuid()).stream());
            return stream;
        }
    }

    @Override
    public void sendProjectAnalysisUpdate(WebHooks.Analysis analysis, Supplier<WebhookPayload> payloadSupplier) {
        List webhooks = (List)this.readWebHooksFrom(analysis.getProjectUuid()).map(dto -> new Webhook(dto.getUuid(), analysis.getProjectUuid(), analysis.getCeTaskUuid(), analysis.getAnalysisUuid(), dto.getName(), dto.getUrl())).collect(MoreCollectors.toList());
        if (webhooks.isEmpty()) {
            return;
        }
        WebhookPayload payload = payloadSupplier.get();
        webhooks.forEach(webhook -> this.asyncExecution.addToQueue(() -> {
            WebhookDelivery delivery = this.caller.call((Webhook)webhook, payload);
            WebHooksImpl.log(delivery);
            this.deliveryStorage.persist(delivery);
        }));
        this.asyncExecution.addToQueue(() -> this.deliveryStorage.purge(analysis.getProjectUuid()));
    }

    private static void log(WebhookDelivery delivery) {
        Optional<String> error = delivery.getErrorMessage();
        if (error.isPresent()) {
            LOGGER.debug("Failed to send webhook '{}' | url={} | message={}", new Object[]{delivery.getWebhook().getName(), delivery.getWebhook().getUrl(), error.get()});
        } else {
            LOGGER.debug("Sent webhook '{}' | url={} | time={}ms | status={}", new Object[]{delivery.getWebhook().getName(), delivery.getWebhook().getUrl(), delivery.getDurationInMs().orElse(-1), delivery.getHttpStatus().orElse(-1)});
        }
    }
}

