/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserTokenDto;
import org.sonar.server.exceptions.ServerException;
import org.sonar.server.usertoken.TokenGenerator;
import org.sonar.server.usertoken.ws.UserTokenSupport;
import org.sonar.server.usertoken.ws.UserTokensWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.UserTokens;

public class GenerateAction
implements UserTokensWsAction {
    private static final int MAX_TOKEN_NAME_LENGTH = 100;
    private final DbClient dbClient;
    private final System2 system;
    private final TokenGenerator tokenGenerator;
    private final UserTokenSupport userTokenSupport;

    public GenerateAction(DbClient dbClient, System2 system, TokenGenerator tokenGenerator, UserTokenSupport userTokenSupport) {
        this.dbClient = dbClient;
        this.system = system;
        this.tokenGenerator = tokenGenerator;
        this.userTokenSupport = userTokenSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("generate").setSince("5.3").setPost(true).setDescription("Generate a user access token. <br />Please keep your tokens secret. They enable to authenticate and analyze projects.<br />If the login is set, it requires administration permissions. Otherwise, a token is generated for the authenticated user.").setResponseExample(this.getClass().getResource("generate-example.json")).setHandler((RequestHandler)this);
        action.createParam("login").setDescription("User login. If not set, the token is generated for the authenticated user.").setExampleValue((Object)"g.hopper");
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(100)).setDescription("Token name").setExampleValue((Object)"Project scan on Travis");
    }

    public void handle(Request request, Response response) throws Exception {
        UserTokens.GenerateWsResponse generateWsResponse = this.doHandle(request);
        WsUtils.writeProtobuf((Message)generateWsResponse, request, response);
    }

    private UserTokens.GenerateWsResponse doHandle(Request request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String name = GenerateAction.getName(request);
            UserDto user = this.userTokenSupport.getUser(dbSession, request);
            this.checkTokenDoesNotAlreadyExists(dbSession, user, name);
            String token = this.tokenGenerator.generate();
            String tokenHash = this.hashToken(dbSession, token);
            UserTokenDto userTokenDto = this.insertTokenInDb(dbSession, user, name, tokenHash);
            UserTokens.GenerateWsResponse generateWsResponse = GenerateAction.buildResponse(userTokenDto, token, user);
            return generateWsResponse;
        }
    }

    private String hashToken(DbSession dbSession, String token) {
        String tokenHash = this.tokenGenerator.hash(token);
        UserTokenDto userToken = this.dbClient.userTokenDao().selectByTokenHash(dbSession, tokenHash);
        if (userToken == null) {
            return tokenHash;
        }
        throw new ServerException(500, "Error while generating token. Please try again.");
    }

    private void checkTokenDoesNotAlreadyExists(DbSession dbSession, UserDto user, String name) {
        UserTokenDto userTokenDto = this.dbClient.userTokenDao().selectByUserAndName(dbSession, user, name);
        WsUtils.checkRequest(userTokenDto == null, "A user token for login '%s' and name '%s' already exists", user.getLogin(), name);
    }

    private static String getName(Request request) {
        String name = request.mandatoryParam("name").trim();
        WsUtils.checkRequest(!name.isEmpty(), "The '%s' parameter must not be blank", "name");
        return name;
    }

    private UserTokenDto insertTokenInDb(DbSession dbSession, UserDto user, String name, String tokenHash) {
        UserTokenDto userTokenDto = new UserTokenDto().setUserUuid(user.getUuid()).setName(name).setTokenHash(tokenHash).setCreatedAt(this.system.now());
        this.dbClient.userTokenDao().insert(dbSession, userTokenDto);
        dbSession.commit();
        return userTokenDto;
    }

    private static UserTokens.GenerateWsResponse buildResponse(UserTokenDto userTokenDto, String token, UserDto user) {
        return UserTokens.GenerateWsResponse.newBuilder().setLogin(user.getLogin()).setName(userTokenDto.getName()).setCreatedAt(DateUtils.formatDateTime((long)userTokenDto.getCreatedAt())).setToken(token).build();
    }
}

