/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ui.ws;

import com.google.protobuf.Message;
import org.sonar.api.platform.Server;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.ui.ws.NavigationWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Navigation;

public class MarketplaceAction
implements NavigationWsAction {
    private final UserSession userSession;
    private final Server server;
    private final DbClient dbClient;

    public MarketplaceAction(UserSession userSession, Server server, DbClient dbClient) {
        this.userSession = userSession;
        this.server = server;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("marketplace").setSince("7.2").setPost(false).setDescription("Provide data to prefill license request forms: the server ID and the total number of lines of code.").setResponseExample(this.getClass().getResource("marketplace-example.json")).setInternal(true).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        Navigation.MarketplaceResponse responsePayload = Navigation.MarketplaceResponse.newBuilder().setNcloc(this.computeNcloc()).setServerId(this.server.getId()).build();
        WsUtils.writeProtobuf((Message)responsePayload, request, response);
    }

    private long computeNcloc() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            long l = this.dbClient.liveMeasureDao().sumNclocOfBiggestLongLivingBranch(dbSession);
            return l;
        }
    }
}

