/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.web.page.Context;
import org.sonar.api.web.page.Page;
import org.sonar.api.web.page.PageDefinition;
import org.sonar.core.extension.CoreExtensionRepository;
import org.sonar.core.platform.PluginRepository;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.ui.page.CorePageDefinition;

@ServerSide
public class PageRepository
implements Startable {
    private final PluginRepository pluginRepository;
    private final CoreExtensionRepository coreExtensionRepository;
    private final List<PageDefinition> definitions;
    private final List<CorePageDefinition> corePageDefinitions;
    private List<Page> pages;

    public PageRepository(PluginRepository pluginRepository, CoreExtensionRepository coreExtensionRepository) {
        this.pluginRepository = pluginRepository;
        this.coreExtensionRepository = coreExtensionRepository;
        this.definitions = Collections.emptyList();
        this.corePageDefinitions = Collections.emptyList();
    }

    public PageRepository(PluginRepository pluginRepository, CoreExtensionRepository coreExtensionRepository, PageDefinition[] pageDefinitions) {
        this.pluginRepository = pluginRepository;
        this.coreExtensionRepository = coreExtensionRepository;
        this.definitions = ImmutableList.copyOf((Object[])pageDefinitions);
        this.corePageDefinitions = Collections.emptyList();
    }

    public PageRepository(PluginRepository pluginRepository, CoreExtensionRepository coreExtensionRepository, CorePageDefinition[] corePageDefinitions) {
        this.pluginRepository = pluginRepository;
        this.coreExtensionRepository = coreExtensionRepository;
        this.definitions = Collections.emptyList();
        this.corePageDefinitions = ImmutableList.copyOf((Object[])corePageDefinitions);
    }

    public PageRepository(PluginRepository pluginRepository, CoreExtensionRepository coreExtensionRepository, PageDefinition[] pageDefinitions, CorePageDefinition[] corePageDefinitions) {
        this.pluginRepository = pluginRepository;
        this.coreExtensionRepository = coreExtensionRepository;
        this.definitions = ImmutableList.copyOf((Object[])pageDefinitions);
        this.corePageDefinitions = ImmutableList.copyOf((Object[])corePageDefinitions);
    }

    public void start() {
        Context context = new Context();
        this.definitions.forEach(definition -> definition.define(context));
        Context coreContext = new Context();
        this.corePageDefinitions.stream().map(CorePageDefinition::getPageDefinition).forEach(definition -> definition.define(coreContext));
        this.pages = (List)Stream.concat(context.getPages().stream().peek(this::checkPluginExists), coreContext.getPages().stream().peek(this::checkCoreExtensionExists)).sorted(Comparator.comparing(Page::getKey)).collect(MoreCollectors.toList());
    }

    public void stop() {
    }

    public List<Page> getGlobalPages(boolean isAdmin) {
        return this.getPages(Page.Scope.GLOBAL, isAdmin, null);
    }

    public List<Page> getOrganizationPages(boolean isAdmin) {
        return this.getPages(Page.Scope.ORGANIZATION, isAdmin, null);
    }

    public List<Page> getComponentPages(boolean isAdmin, String qualifierKey) {
        Page.Qualifier qualifier = Page.Qualifier.fromKey((String)qualifierKey);
        return qualifier == null ? Collections.emptyList() : this.getPages(Page.Scope.COMPONENT, isAdmin, qualifier);
    }

    private List<Page> getPages(Page.Scope scope, boolean isAdmin, @Nullable Page.Qualifier qualifier) {
        return (List)this.getAllPages().stream().filter(p -> p.getScope().equals((Object)scope)).filter(p -> p.isAdmin() == isAdmin).filter(p -> !Page.Scope.COMPONENT.equals((Object)p.getScope()) || p.getComponentQualifiers().contains(qualifier)).collect(MoreCollectors.toList());
    }

    @VisibleForTesting
    List<Page> getAllPages() {
        return Objects.requireNonNull(this.pages, "Pages haven't been initialized yet");
    }

    private void checkPluginExists(Page page) {
        String pluginKey = page.getPluginKey();
        Preconditions.checkState((boolean)this.pluginRepository.hasPlugin(pluginKey), (String)"Page '%s' references plugin '%s' that does not exist", (Object[])new Object[]{page.getName(), pluginKey});
    }

    private void checkCoreExtensionExists(Page page) {
        String coreExtensionName = page.getPluginKey();
        Preconditions.checkState((boolean)this.coreExtensionRepository.isInstalled(coreExtensionName), (String)"Page '%s' references Core Extension '%s' which is not installed", (Object[])new Object[]{page.getName(), coreExtensionName});
    }
}

