/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.test.ws;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.SearchResult;
import org.sonar.server.test.index.CoveredFileDoc;
import org.sonar.server.test.index.TestDoc;
import org.sonar.server.test.index.TestIndex;
import org.sonar.server.test.ws.TestsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Tests;

public class ListAction
implements TestsWsAction {
    public static final String TEST_ID = "testId";
    public static final String TEST_FILE_ID = "testFileId";
    public static final String TEST_FILE_KEY = "testFileKey";
    public static final String SOURCE_FILE_ID = "sourceFileId";
    public static final String SOURCE_FILE_KEY = "sourceFileKey";
    public static final String SOURCE_FILE_LINE_NUMBER = "sourceFileLineNumber";
    public static final String PARAM_BRANCH = "branch";
    public static final String PARAM_PULL_REQUEST = "pullRequest";
    private final DbClient dbClient;
    private final TestIndex testIndex;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public ListAction(DbClient dbClient, TestIndex testIndex, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.testIndex = testIndex;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("list").setDescription(String.format("Get the list of tests either in a test file or that test a given line of source code.<br /> Requires 'Browse' permission on the file's project.<br /> One (and only one) of the following combination of parameters must be provided: <ul><li>%s - get a specific test</li><li>%s - get the tests in a test file</li><li>%s - get the tests in a test file</li><li>%s and %6$s - get the tests that cover a specific line of code</li><li>%s and %6$s - get the tests that cover a specific line of code</li></ul>", TEST_ID, TEST_FILE_ID, TEST_FILE_KEY, SOURCE_FILE_ID, SOURCE_FILE_KEY, SOURCE_FILE_LINE_NUMBER)).setSince("5.2").setResponseExample(Resources.getResource(this.getClass(), (String)"tests-example-list.json")).setDeprecatedSince("5.6").setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.6", "\"fileBranch\" field is now returned")}).setChangelog(new Change[]{new Change("7.1", "\"filePullRequest\" field is now returned")}).addPagingParams(100, 500);
        action.createParam(TEST_FILE_ID).setDescription("ID of test file").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam(TEST_FILE_KEY).setDescription("Key of test file").setExampleValue((Object)"MY_PROJECT:src/test/java/foo/BarTest.java");
        action.createParam(TEST_ID).setDescription("ID of test").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz");
        action.createParam(SOURCE_FILE_ID).setDescription("ID of source file. Must be provided with the source file line number.").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL0");
        action.createParam(SOURCE_FILE_KEY).setSince("5.4").setDescription("Key of source file. Must be provided with the source file line number.").setExampleValue((Object)"my_project:/src/foo/Bar.php");
        action.createParam(SOURCE_FILE_LINE_NUMBER).setDescription("Source file line number. Must be provided with the source file ID or key.").setExampleValue((Object)"10");
        action.createParam(PARAM_BRANCH).setDescription("Branch key").setSince("6.6").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam(PARAM_PULL_REQUEST).setDescription("Pull request id").setSince("7.1").setInternal(true).setExampleValue((Object)"5461");
    }

    public void handle(Request request, Response response) throws Exception {
        Map<String, ComponentDto> componentsByTestFileUuid;
        SearchResult<TestDoc> tests;
        String testUuid = request.param(TEST_ID);
        String testFileUuid = request.param(TEST_FILE_ID);
        String testFileKey = request.param(TEST_FILE_KEY);
        String sourceFileUuid = request.param(SOURCE_FILE_ID);
        String sourceFileKey = request.param(SOURCE_FILE_KEY);
        String branch = request.param(PARAM_BRANCH);
        String pullRequest = request.param(PARAM_PULL_REQUEST);
        Integer sourceFileLineNumber = request.paramAsInt(SOURCE_FILE_LINE_NUMBER);
        SearchOptions searchOptions = new SearchOptions().setPage(request.mandatoryParamAsInt("p"), request.mandatoryParamAsInt("ps"));
        DbSession dbSession = this.dbClient.openSession(false);
        Object object = null;
        try {
            tests = this.searchTests(dbSession, testUuid, testFileUuid, testFileKey, sourceFileUuid, sourceFileKey, branch, pullRequest, sourceFileLineNumber, searchOptions);
            componentsByTestFileUuid = this.buildComponentsByTestFileUuid(dbSession, tests.getDocs());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dbSession != null) {
                if (object != null) {
                    try {
                        dbSession.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dbSession.close();
                }
            }
        }
        Tests.ListResponse.Builder responseBuilder = Tests.ListResponse.newBuilder();
        responseBuilder.setPaging(Common.Paging.newBuilder().setPageIndex(searchOptions.getPage()).setPageSize(searchOptions.getLimit()).setTotal((int)tests.getTotal()).build());
        for (TestDoc testDoc : tests.getDocs()) {
            Tests.Test.Builder testBuilder = Tests.Test.newBuilder();
            testBuilder.setId(testDoc.testUuid());
            testBuilder.setName(StringUtils.defaultString((String)testDoc.name()));
            testBuilder.setFileId(testDoc.fileUuid());
            ComponentDto component = componentsByTestFileUuid.get(testDoc.fileUuid());
            if (component != null) {
                testBuilder.setFileKey(component.getKey());
                testBuilder.setFileName(component.longName());
                Protobuf.setNullable((Object)component.getBranch(), arg_0 -> ((Tests.Test.Builder)testBuilder).setFileBranch(arg_0));
                Protobuf.setNullable((Object)component.getPullRequest(), arg_0 -> ((Tests.Test.Builder)testBuilder).setFilePullRequest(arg_0));
            }
            testBuilder.setStatus(Tests.TestStatus.valueOf((String)testDoc.status()));
            if (testDoc.durationInMs() != null) {
                testBuilder.setDurationInMs(testDoc.durationInMs().longValue());
            }
            testBuilder.setCoveredLines(ListAction.coveredLines(testDoc.coveredFiles()));
            if (testDoc.message() != null) {
                testBuilder.setMessage(testDoc.message());
            }
            if (testDoc.stackTrace() != null) {
                testBuilder.setStacktrace(testDoc.stackTrace());
            }
            responseBuilder.addTests(testBuilder.build());
        }
        WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
    }

    private static int coveredLines(List<CoveredFileDoc> coveredFiles) {
        int numberOfLinesCovered = 0;
        for (CoveredFileDoc coveredFile : coveredFiles) {
            numberOfLinesCovered += coveredFile.coveredLines().size();
        }
        return numberOfLinesCovered;
    }

    private Map<String, ComponentDto> buildComponentsByTestFileUuid(DbSession dbSession, List<TestDoc> tests) {
        List fileUuids = Lists.transform(tests, (Function)new TestToFileUuidFunction());
        List components = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)fileUuids);
        return Maps.uniqueIndex((Iterable)components, ComponentDto::uuid);
    }

    private SearchResult<TestDoc> searchTests(DbSession dbSession, @Nullable String testUuid, @Nullable String testFileUuid, @Nullable String testFileKey, @Nullable String sourceFileUuid, @Nullable String sourceFileKey, @Nullable String branch, @Nullable String pullRequest, @Nullable Integer sourceFileLineNumber, SearchOptions searchOptions) {
        if (testUuid != null) {
            TestDoc testDoc = WsUtils.checkFoundWithOptional(this.testIndex.getNullableByTestUuid(testUuid), "Test with id '%s' is not found", testUuid);
            this.checkComponentUuidPermission(dbSession, testDoc.fileUuid());
            return this.testIndex.searchByTestUuid(testUuid, searchOptions);
        }
        if (testFileUuid != null) {
            this.checkComponentUuidPermission(dbSession, testFileUuid);
            return this.testIndex.searchByTestFileUuid(testFileUuid, searchOptions);
        }
        if (testFileKey != null) {
            ComponentDto testFile = this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, testFileKey, branch, pullRequest);
            this.userSession.checkComponentPermission("codeviewer", testFile);
            return this.testIndex.searchByTestFileUuid(testFile.uuid(), searchOptions);
        }
        if (sourceFileUuid != null && sourceFileLineNumber != null) {
            ComponentDto sourceFile = this.componentFinder.getByUuid(dbSession, sourceFileUuid);
            this.userSession.checkComponentPermission("codeviewer", sourceFile);
            return this.testIndex.searchBySourceFileUuidAndLineNumber(sourceFile.uuid(), sourceFileLineNumber, searchOptions);
        }
        if (sourceFileKey != null && sourceFileLineNumber != null) {
            ComponentDto sourceFile = this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, sourceFileKey, branch, pullRequest);
            this.userSession.checkComponentPermission("codeviewer", sourceFile);
            return this.testIndex.searchBySourceFileUuidAndLineNumber(sourceFile.uuid(), sourceFileLineNumber, searchOptions);
        }
        throw new IllegalArgumentException("One (and only one) of the following combination of parameters must be provided: 1) test UUID. 2) test file UUID. 3) test file key. 4) source file ID or key with a source file line number.");
    }

    private void checkComponentUuidPermission(DbSession dbSession, String componentUuid) {
        ComponentDto component = this.componentFinder.getByUuid(dbSession, componentUuid);
        this.userSession.checkComponentPermission("codeviewer", component);
    }

    private static class TestToFileUuidFunction
    implements Function<TestDoc, String> {
        private TestToFileUuidFunction() {
        }

        public String apply(@Nonnull TestDoc testDoc) {
            return testDoc.fileUuid();
        }
    }
}

