/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.server.source.DecorationDataHolder;
import org.sonar.server.source.HtmlTextDecorator;

public class HtmlSourceDecorator {
    @CheckForNull
    public String getDecoratedSourceAsHtml(@Nullable String sourceLine, @Nullable String highlighting, @Nullable String symbols) {
        HtmlTextDecorator textDecorator;
        List<String> decoratedSource;
        if (sourceLine == null) {
            return null;
        }
        DecorationDataHolder decorationDataHolder = new DecorationDataHolder();
        if (StringUtils.isNotBlank((String)highlighting)) {
            decorationDataHolder.loadSyntaxHighlightingData(highlighting);
        }
        if (StringUtils.isNotBlank((String)symbols)) {
            decorationDataHolder.loadLineSymbolReferences(symbols);
        }
        if ((decoratedSource = (textDecorator = new HtmlTextDecorator()).decorateTextWithHtml(sourceLine, decorationDataHolder, 1, 1)) == null) {
            return null;
        }
        if (decoratedSource.isEmpty()) {
            return "";
        }
        return decoratedSource.get(0);
    }
}

