/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableTable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.db.property.PropertyDto;

public class Setting {
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".").omitEmptyStrings();
    private final String key;
    private final Long componentId;
    private final String value;
    private final PropertyDefinition definition;
    private final List<Map<String, String>> propertySets;
    private final boolean isDefault;

    private Setting(PropertyDto propertyDto, List<PropertyDto> propertyDtoSetValues, @Nullable PropertyDefinition definition) {
        this.key = propertyDto.getKey();
        this.value = propertyDto.getValue();
        this.componentId = propertyDto.getResourceId();
        this.definition = definition;
        this.propertySets = Setting.buildPropertySetValuesAsMap(this.key, propertyDtoSetValues);
        this.isDefault = false;
    }

    private Setting(PropertyDefinition definition) {
        this.key = definition.key();
        this.value = definition.defaultValue();
        this.componentId = null;
        this.definition = definition;
        this.propertySets = Collections.emptyList();
        this.isDefault = true;
    }

    public static Setting createFromDto(PropertyDto propertyDto, List<PropertyDto> propertyDtoSetValues, @Nullable PropertyDefinition definition) {
        return new Setting(propertyDto, propertyDtoSetValues, definition);
    }

    public static Setting createFromDefinition(PropertyDefinition definition) {
        return new Setting(definition);
    }

    public String getKey() {
        return this.key;
    }

    @CheckForNull
    public Long getComponentId() {
        return this.componentId;
    }

    @CheckForNull
    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public List<Map<String, String>> getPropertySets() {
        return this.propertySets;
    }

    private static List<Map<String, String>> buildPropertySetValuesAsMap(String propertyKey, List<PropertyDto> propertySets) {
        if (propertySets.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableTable.Builder tableBuilder = new ImmutableTable.Builder();
        propertySets.forEach(property -> {
            String keyWithoutSettingKey = property.getKey().replace(propertyKey + ".", "");
            List setIdWithFieldKey = DOT_SPLITTER.splitToList((CharSequence)keyWithoutSettingKey);
            String setId = (String)setIdWithFieldKey.get(0);
            String fieldKey = keyWithoutSettingKey.replaceFirst(setId + ".", "");
            tableBuilder.put((Object)setId, (Object)fieldKey, (Object)property.getValue());
        });
        ImmutableTable table = tableBuilder.build();
        return table.rowKeySet().stream().map(arg_0 -> ((ImmutableTable)table).row(arg_0)).collect(Collectors.toList());
    }
}

