/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.setting.ws.SettingValidations;
import org.sonar.server.setting.ws.SettingsUpdater;
import org.sonar.server.setting.ws.SettingsWsAction;
import org.sonar.server.setting.ws.SettingsWsSupport;
import org.sonar.server.user.UserSession;

public class ResetAction
implements SettingsWsAction {
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final SettingsUpdater settingsUpdater;
    private final UserSession userSession;
    private final PropertyDefinitions definitions;
    private final SettingValidations validations;

    public ResetAction(DbClient dbClient, ComponentFinder componentFinder, SettingsUpdater settingsUpdater, UserSession userSession, PropertyDefinitions definitions, SettingValidations validations) {
        this.dbClient = dbClient;
        this.settingsUpdater = settingsUpdater;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
        this.definitions = definitions;
        this.validations = validations;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("reset").setDescription("Remove a setting value.<br>The settings defined in config/sonar.properties are read-only and can't be changed.<br/>Requires one of the following permissions: <ul><li>'Administer System'</li><li>'Administer' rights on the specified component</li></ul>").setSince("6.1").setChangelog(new Change[]{new Change("7.1", "The settings defined in config/sonar.properties are read-only and can't be changed")}).setPost(true).setHandler((RequestHandler)this);
        action.createParam("keys").setDescription("Comma-separated list of keys").setExampleValue((Object)"sonar.links.scm,sonar.debt.hoursInDay").setRequired(true);
        action.createParam("component").setDescription("Component key").setDeprecatedKey("componentKey", "6.3").setExampleValue((Object)"my_project");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        action.createParam("pullRequest").setDescription("Pull request id").setExampleValue((Object)"5461").setInternal(true).setSince("7.1");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ResetRequest resetRequest = ResetAction.toWsRequest(request);
            Optional<ComponentDto> component = this.getComponent(dbSession, resetRequest);
            this.checkPermissions(component);
            resetRequest.getKeys().forEach(key -> {
                SettingsWsSupport.validateKey(key);
                SettingValidations.SettingData data = new SettingValidations.SettingData((String)key, Collections.emptyList(), component.orElse(null));
                ImmutableList.of(this.validations.scope(), this.validations.qualifier()).forEach(validation -> validation.accept(data));
            });
            List<String> keys = this.getKeys(resetRequest);
            if (component.isPresent()) {
                this.settingsUpdater.deleteComponentSettings(dbSession, component.get(), keys);
            } else {
                this.settingsUpdater.deleteGlobalSettings(dbSession, keys);
            }
            dbSession.commit();
            response.noContent();
        }
    }

    private List<String> getKeys(ResetRequest request) {
        return new ArrayList<String>((Collection)request.getKeys().stream().map(key -> {
            PropertyDefinition definition = this.definitions.get(key);
            return definition != null ? definition.key() : key;
        }).collect(MoreCollectors.toSet()));
    }

    private static ResetRequest toWsRequest(Request request) {
        return new ResetRequest().setKeys(request.mandatoryParamAsStrings("keys")).setComponent(request.param("component")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest"));
    }

    private Optional<ComponentDto> getComponent(DbSession dbSession, ResetRequest request) {
        String componentKey = request.getComponent();
        if (componentKey == null) {
            return Optional.empty();
        }
        return Optional.of(this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentKey, request.getBranch(), request.getPullRequest()));
    }

    private void checkPermissions(Optional<ComponentDto> component) {
        if (component.isPresent()) {
            this.userSession.checkComponentPermission("admin", component.get());
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }

    private static class ResetRequest {
        private String branch;
        private String pullRequest;
        private String component;
        private List<String> keys;

        private ResetRequest() {
        }

        public ResetRequest setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        @CheckForNull
        public String getBranch() {
            return this.branch;
        }

        public ResetRequest setPullRequest(@Nullable String pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        @CheckForNull
        public String getPullRequest() {
            return this.pullRequest;
        }

        public ResetRequest setComponent(@Nullable String component) {
            this.component = component;
            return this;
        }

        @CheckForNull
        public String getComponent() {
            return this.component;
        }

        public ResetRequest setKeys(List<String> keys) {
            this.keys = keys;
            return this;
        }

        public List<String> getKeys() {
            return this.keys;
        }
    }
}

