/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.PropertyFieldDefinition;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.setting.ws.SettingsWs;
import org.sonar.server.setting.ws.SettingsWsAction;
import org.sonar.server.setting.ws.SettingsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Settings;

public class ListDefinitionsAction
implements SettingsWsAction {
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;
    private final PropertyDefinitions propertyDefinitions;
    private final SettingsWsSupport settingsWsSupport;

    public ListDefinitionsAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession, PropertyDefinitions propertyDefinitions, SettingsWsSupport settingsWsSupport) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
        this.propertyDefinitions = propertyDefinitions;
        this.settingsWsSupport = settingsWsSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("list_definitions").setDescription("List settings definitions.<br>Requires 'Browse' permission when a component is specified<br/>", new Object[]{"To access licensed settings, authentication is required<br/>To access secured settings, one of the following permissions is required: <ul><li>'Execute Analysis'</li><li>'Administer System'</li><li>'Administer' rights on the specified component</li></ul>"}).setResponseExample(this.getClass().getResource("list_definitions-example.json")).setSince("6.3").setHandler((RequestHandler)this);
        action.createParam("component").setDescription("Component key").setExampleValue((Object)"my_project");
        this.settingsWsSupport.addBranchParam(action);
        this.settingsWsSupport.addPullRequestParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        WsUtils.writeProtobuf((Message)this.doHandle(request), request, response);
    }

    private Settings.ListDefinitionsWsResponse doHandle(Request request) {
        ListDefinitionsRequest wsRequest = ListDefinitionsAction.toWsRequest(request);
        Optional<ComponentDto> component = this.loadComponent(wsRequest);
        Optional<String> qualifier = ListDefinitionsAction.getQualifier(component);
        Settings.ListDefinitionsWsResponse.Builder wsResponse = Settings.ListDefinitionsWsResponse.newBuilder();
        this.propertyDefinitions.getAll().stream().filter(definition -> qualifier.map(s -> definition.qualifiers().contains(s)).orElseGet(() -> ((PropertyDefinition)definition).global())).filter(definition -> wsRequest.getBranch() == null || SettingsWs.SETTING_ON_BRANCHES.contains(definition.key())).filter(this.settingsWsSupport.isDefinitionVisible(component)).sorted(Comparator.comparing(PropertyDefinition::category, String::compareToIgnoreCase).thenComparingInt(PropertyDefinition::index).thenComparing(PropertyDefinition::name, String::compareToIgnoreCase)).forEach(definition -> this.addDefinition((PropertyDefinition)definition, wsResponse));
        return wsResponse.build();
    }

    private static ListDefinitionsRequest toWsRequest(Request request) {
        return new ListDefinitionsRequest().setComponent(request.param("component")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest"));
    }

    private static Optional<String> getQualifier(Optional<ComponentDto> component) {
        return component.isPresent() ? Optional.of(component.get().qualifier()) : Optional.empty();
    }

    private Optional<ComponentDto> loadComponent(ListDefinitionsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String componentKey = request.getComponent();
            if (componentKey == null) {
                Optional<ComponentDto> optional = Optional.empty();
                return optional;
            }
            ComponentDto component = this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentKey, request.getBranch(), request.getPullRequest());
            this.userSession.checkComponentPermission("user", component);
            Optional<ComponentDto> optional = Optional.of(component);
            return optional;
        }
    }

    private void addDefinition(PropertyDefinition definition, Settings.ListDefinitionsWsResponse.Builder wsResponse) {
        List fields;
        String key = definition.key();
        Settings.Definition.Builder builder = wsResponse.addDefinitionsBuilder().setKey(key).setType(Settings.Type.valueOf((String)definition.type().name())).setMultiValues(definition.multiValues());
        Protobuf.setNullable((Object)Strings.emptyToNull((String)definition.deprecatedKey()), arg_0 -> ((Settings.Definition.Builder)builder).setDeprecatedKey(arg_0));
        Protobuf.setNullable((Object)Strings.emptyToNull((String)definition.name()), arg_0 -> ((Settings.Definition.Builder)builder).setName(arg_0));
        Protobuf.setNullable((Object)Strings.emptyToNull((String)definition.description()), arg_0 -> ((Settings.Definition.Builder)builder).setDescription(arg_0));
        String category = this.propertyDefinitions.getCategory(key);
        Protobuf.setNullable((Object)Strings.emptyToNull((String)category), arg_0 -> ((Settings.Definition.Builder)builder).setCategory(arg_0));
        String subCategory = this.propertyDefinitions.getSubCategory(key);
        Protobuf.setNullable((Object)Strings.emptyToNull((String)subCategory), arg_0 -> ((Settings.Definition.Builder)builder).setSubCategory(arg_0));
        Protobuf.setNullable((Object)Strings.emptyToNull((String)definition.defaultValue()), arg_0 -> ((Settings.Definition.Builder)builder).setDefaultValue(arg_0));
        List options = definition.options();
        if (!options.isEmpty()) {
            builder.addAllOptions((Iterable)options);
        }
        if (!(fields = definition.fields()).isEmpty()) {
            fields.forEach(fieldDefinition -> ListDefinitionsAction.addField(fieldDefinition, builder));
        }
    }

    private static void addField(PropertyFieldDefinition fieldDefinition, Settings.Definition.Builder builder) {
        builder.addFieldsBuilder().setKey(fieldDefinition.key()).setName(fieldDefinition.name()).setDescription(fieldDefinition.description()).setType(Settings.Type.valueOf((String)fieldDefinition.type().name())).addAllOptions((Iterable)fieldDefinition.options()).build();
    }

    private static class ListDefinitionsRequest {
        private String branch;
        private String component;
        private String pullRequest;

        private ListDefinitionsRequest() {
        }

        public ListDefinitionsRequest setComponent(@Nullable String component) {
            this.component = component;
            return this;
        }

        @CheckForNull
        public String getComponent() {
            return this.component;
        }

        public ListDefinitionsRequest setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        @CheckForNull
        public String getBranch() {
            return this.branch;
        }

        public ListDefinitionsRequest setPullRequest(@Nullable String pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }

        @CheckForNull
        public String getPullRequest() {
            return this.pullRequest;
        }
    }
}

