/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.io.Resources;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.rule.index.RuleIndex;
import org.sonar.server.rule.ws.RulesWsAction;
import org.sonar.server.ws.WsUtils;

public class TagsAction
implements RulesWsAction {
    private final RuleIndex ruleIndex;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public TagsAction(RuleIndex ruleIndex, DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.ruleIndex = ruleIndex;
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("tags").setDescription("List rule tags").setSince("4.4").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-tags.json"));
        action.createSearchQuery("misra", new String[]{"tags"});
        action.createPageSize(10, 100);
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.4");
    }

    public void handle(Request request, Response response) {
        OrganizationDto organization = this.getOrganization(request.param("organization"));
        String query = request.param("q");
        int pageSize = request.mandatoryParamAsInt("ps");
        List<String> tags = this.ruleIndex.listTags(organization, query, pageSize == 0 ? Integer.MAX_VALUE : pageSize);
        TagsAction.writeResponse(response, tags);
    }

    private OrganizationDto getOrganization(@Nullable String organizationKey) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String organizationOrDefaultKey = Optional.ofNullable(organizationKey).orElseGet(this.defaultOrganizationProvider.get()::getKey);
            OrganizationDto organizationDto = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationOrDefaultKey), "No organization with key '%s'", organizationOrDefaultKey);
            return organizationDto;
        }
    }

    private static void writeResponse(Response response, List<String> tags) {
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().name("tags").beginArray();
            tags.forEach(arg_0 -> ((JsonWriter)json).value(arg_0));
            json.endArray().endObject();
        }
    }
}

