/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.index;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.qualityprofile.ActiveRuleInheritance;

public class ActiveRuleDoc
extends BaseDoc {
    public ActiveRuleDoc(long id) {
        super(Maps.newHashMapWithExpectedSize((int)10));
        this.setField("id", String.valueOf(id));
    }

    public ActiveRuleDoc(Map<String, Object> source) {
        super(source);
    }

    @Override
    public String getId() {
        return (String)this.getField("id");
    }

    @Override
    public String getRouting() {
        return this.getRuleIdAsString();
    }

    @Override
    public String getParent() {
        return this.getRuleIdAsString();
    }

    private String getRuleIdAsString() {
        return (String)this.getField("ruleId");
    }

    ActiveRuleDoc setRuleId(int ruleId) {
        this.setField("ruleId", String.valueOf(ruleId));
        return this;
    }

    String getSeverity() {
        return (String)this.getNullableField("severity");
    }

    ActiveRuleDoc setSeverity(@Nullable String s) {
        this.setField("severity", s);
        return this;
    }

    String getRuleProfileUuid() {
        return (String)this.getField("ruleProfile");
    }

    ActiveRuleDoc setRuleProfileUuid(String s) {
        this.setField("ruleProfile", s);
        return this;
    }

    ActiveRuleInheritance getInheritance() {
        String inheritance = (String)this.getNullableField("inheritance");
        if (inheritance == null || inheritance.isEmpty() || StringUtils.containsIgnoreCase((String)inheritance, (String)"none")) {
            return ActiveRuleInheritance.NONE;
        }
        if (StringUtils.containsIgnoreCase((String)inheritance, (String)"herit")) {
            return ActiveRuleInheritance.INHERITED;
        }
        if (StringUtils.containsIgnoreCase((String)inheritance, (String)"over")) {
            return ActiveRuleInheritance.OVERRIDES;
        }
        throw new IllegalStateException("Value \"" + inheritance + "\" is not valid for rule's inheritance");
    }

    public ActiveRuleDoc setInheritance(@Nullable String s) {
        this.setField("inheritance", s);
        return this;
    }
}

