/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualitygate.ws.QualityGateDetailsFormatter;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class ProjectStatusAction
implements QualityGatesWsAction {
    private static final String QG_STATUSES_ONE_LINE = Arrays.stream(Qualitygates.ProjectStatusResponse.Status.values()).map(Enum::toString).collect(Collectors.joining(", "));
    private static final String MSG_ONE_PARAMETER_ONLY = String.format("Either '%s', '%s' or '%s' must be provided", "analysisId", "projectId", "projectKey");
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final UserSession userSession;

    public ProjectStatusAction(DbClient dbClient, ComponentFinder componentFinder, UserSession userSession) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("project_status").setDescription(String.format("Get the quality gate status of a project or a Compute Engine task.<br />" + MSG_ONE_PARAMETER_ONLY + "<br />The different statuses returned are: %s. The %s status is returned when there is no quality gate associated with the analysis.<br />Returns an HTTP code 404 if the analysis associated with the task is not found or does not exist.<br />Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li><li>'Browse' on the specified project</li></ul>", QG_STATUSES_ONE_LINE, Qualitygates.ProjectStatusResponse.Status.NONE)).setResponseExample(this.getClass().getResource("project_status-example.json")).setSince("5.3").setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("6.4", "The field 'ignoredConditions' is added to the response")});
        action.createParam("analysisId").setDescription("Analysis id").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FL1");
        action.createParam("projectId").setSince("5.4").setDescription("Project id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setSince("5.4").setDescription("Project key").setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        String analysisId = request.param("analysisId");
        String projectId = request.param("projectId");
        String projectKey = request.param("projectKey");
        WsUtils.checkRequest(!Strings.isNullOrEmpty((String)analysisId) ^ !Strings.isNullOrEmpty((String)projectId) ^ !Strings.isNullOrEmpty((String)projectKey), MSG_ONE_PARAMETER_ONLY, new Object[0]);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Qualitygates.ProjectStatusResponse projectStatusResponse = this.doHandle(dbSession, analysisId, projectId, projectKey);
            WsUtils.writeProtobuf((Message)projectStatusResponse, request, response);
        }
    }

    private Qualitygates.ProjectStatusResponse doHandle(DbSession dbSession, @Nullable String analysisId, @Nullable String projectId, @Nullable String projectKey) {
        ProjectAndSnapshot projectAndSnapshot = this.getProjectAndSnapshot(dbSession, analysisId, projectId, projectKey);
        this.checkPermission(projectAndSnapshot.project);
        Optional<String> measureData = this.loadQualityGateDetails(dbSession, projectAndSnapshot, analysisId != null);
        return Qualitygates.ProjectStatusResponse.newBuilder().setProjectStatus(new QualityGateDetailsFormatter(measureData, projectAndSnapshot.snapshotDto).format()).build();
    }

    private ProjectAndSnapshot getProjectAndSnapshot(DbSession dbSession, @Nullable String analysisId, @Nullable String projectId, @Nullable String projectKey) {
        if (!Strings.isNullOrEmpty((String)analysisId)) {
            return this.getSnapshotThenProject(dbSession, analysisId);
        }
        if (!Strings.isNullOrEmpty((String)projectId) ^ !Strings.isNullOrEmpty((String)projectKey)) {
            return this.getProjectThenSnapshot(dbSession, projectId, projectKey);
        }
        throw BadRequestException.create(MSG_ONE_PARAMETER_ONLY);
    }

    private ProjectAndSnapshot getProjectThenSnapshot(DbSession dbSession, String projectId, String projectKey) {
        ComponentDto projectDto = this.componentFinder.getByUuidOrKey(dbSession, projectId, projectKey, ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
        Optional snapshot = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, projectDto.projectUuid());
        return new ProjectAndSnapshot(projectDto, snapshot.orElse(null));
    }

    private ProjectAndSnapshot getSnapshotThenProject(DbSession dbSession, String analysisUuid) {
        SnapshotDto snapshotDto = this.getSnapshot(dbSession, analysisUuid);
        ComponentDto projectDto = this.dbClient.componentDao().selectOrFailByUuid(dbSession, snapshotDto.getComponentUuid());
        return new ProjectAndSnapshot(projectDto, snapshotDto);
    }

    private SnapshotDto getSnapshot(DbSession dbSession, String analysisUuid) {
        Optional snapshotDto = this.dbClient.snapshotDao().selectByUuid(dbSession, analysisUuid);
        return (SnapshotDto)WsUtils.checkFoundWithOptional(snapshotDto, "Analysis with id '%s' is not found", analysisUuid);
    }

    private Optional<String> loadQualityGateDetails(DbSession dbSession, ProjectAndSnapshot projectAndSnapshot, boolean onAnalysis) {
        if (onAnalysis) {
            if (!projectAndSnapshot.snapshotDto.isPresent()) {
                return Optional.empty();
            }
            String analysisUuid = ((SnapshotDto)projectAndSnapshot.snapshotDto.get()).getUuid();
            return this.dbClient.measureDao().selectMeasure(dbSession, analysisUuid, projectAndSnapshot.project.projectUuid(), "quality_gate_details").map(MeasureDto::getData);
        }
        Optional measure = this.dbClient.liveMeasureDao().selectMeasure(dbSession, projectAndSnapshot.project.projectUuid(), "quality_gate_details");
        return measure.map(LiveMeasureDto::getDataAsString);
    }

    private void checkPermission(ComponentDto project) {
        if (!this.userSession.hasComponentPermission("admin", project) && !this.userSession.hasComponentPermission("user", project)) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
    }

    @Immutable
    private static class ProjectAndSnapshot {
        private final ComponentDto project;
        private final Optional<SnapshotDto> snapshotDto;

        private ProjectAndSnapshot(ComponentDto project, @Nullable SnapshotDto snapshotDto) {
            this.project = project;
            this.snapshotDto = Optional.ofNullable(snapshotDto);
        }
    }
}

