/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.sonar.api.measures.Metric;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.ConditionEvaluator;
import org.sonar.server.qualitygate.EvaluatedCondition;
import org.sonar.server.qualitygate.EvaluatedQualityGate;
import org.sonar.server.qualitygate.QualityGate;
import org.sonar.server.qualitygate.QualityGateEvaluator;

public class QualityGateEvaluatorImpl
implements QualityGateEvaluator {
    private static final int MAXIMUM_NEW_LINES_FOR_SMALL_CHANGESETS = 20;
    private static final Set<String> METRICS_TO_IGNORE_ON_SMALL_CHANGESETS = ImmutableSet.of((Object)"new_coverage", (Object)"new_line_coverage", (Object)"new_branch_coverage", (Object)"new_duplicated_lines_density", (Object)"new_duplicated_lines", (Object)"new_duplicated_blocks", (Object[])new String[0]);

    @Override
    public EvaluatedQualityGate evaluate(QualityGate gate, QualityGateEvaluator.Measures measures) {
        EvaluatedQualityGate.Builder result = EvaluatedQualityGate.newBuilder().setQualityGate(gate);
        boolean isSmallChangeset = QualityGateEvaluatorImpl.isSmallChangeset(measures);
        Multimap conditionsPerMetric = (Multimap)gate.getConditions().stream().collect(MoreCollectors.index(Condition::getMetricKey, Function.identity()));
        for (Map.Entry entry : conditionsPerMetric.asMap().entrySet()) {
            String metricKey = (String)entry.getKey();
            Collection conditionsOnSameMetric = (Collection)entry.getValue();
            EvaluatedCondition evaluation = QualityGateEvaluatorImpl.evaluateConditionsOnMetric(conditionsOnSameMetric, measures);
            if (isSmallChangeset && evaluation.getStatus() != EvaluatedCondition.EvaluationStatus.OK && METRICS_TO_IGNORE_ON_SMALL_CHANGESETS.contains(metricKey)) {
                result.addCondition(new EvaluatedCondition(evaluation.getCondition(), EvaluatedCondition.EvaluationStatus.OK, evaluation.getValue().orElse(null)));
                result.setIgnoredConditionsOnSmallChangeset(true);
                continue;
            }
            result.addCondition(evaluation);
        }
        result.setStatus(QualityGateEvaluatorImpl.overallStatusOf(result.getEvaluatedConditions()));
        return result.build();
    }

    @Override
    public Set<String> getMetricKeys(QualityGate gate) {
        HashSet<String> metricKeys = new HashSet<String>();
        metricKeys.add("new_lines");
        for (Condition condition : gate.getConditions()) {
            metricKeys.add(condition.getMetricKey());
        }
        return metricKeys;
    }

    private static boolean isSmallChangeset(QualityGateEvaluator.Measures measures) {
        Optional<QualityGateEvaluator.Measure> newLines = measures.get("new_lines");
        return newLines.isPresent() && newLines.get().getLeakValue().isPresent() && newLines.get().getLeakValue().getAsDouble() < 20.0;
    }

    private static EvaluatedCondition evaluateConditionsOnMetric(Collection<Condition> conditionsOnSameMetric, QualityGateEvaluator.Measures measures) {
        EvaluatedCondition leakEvaluation = null;
        EvaluatedCondition absoluteEvaluation = null;
        for (Condition condition : conditionsOnSameMetric) {
            if (condition.isOnLeakPeriod()) {
                leakEvaluation = ConditionEvaluator.evaluate(condition, measures);
                continue;
            }
            absoluteEvaluation = ConditionEvaluator.evaluate(condition, measures);
        }
        if (leakEvaluation == null) {
            return Objects.requireNonNull(absoluteEvaluation, "Evaluation of absolute value can't be null on conditions " + conditionsOnSameMetric);
        }
        if (absoluteEvaluation == null) {
            return Objects.requireNonNull(leakEvaluation, "Evaluation of leak value can't be null on conditions " + conditionsOnSameMetric);
        }
        if (absoluteEvaluation.getStatus().compareTo(leakEvaluation.getStatus()) > 0) {
            return absoluteEvaluation;
        }
        return leakEvaluation;
    }

    private static Metric.Level overallStatusOf(Set<EvaluatedCondition> conditions) {
        Set statuses = (Set)conditions.stream().map(EvaluatedCondition::getStatus).collect(MoreCollectors.toEnumSet(EvaluatedCondition.EvaluationStatus.class));
        if (statuses.contains((Object)EvaluatedCondition.EvaluationStatus.ERROR)) {
            return Metric.Level.ERROR;
        }
        if (statuses.contains((Object)EvaluatedCondition.EvaluationStatus.WARN)) {
            return Metric.Level.WARN;
        }
        return Metric.Level.OK;
    }
}

