/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Condition {
    private final String metricKey;
    private final Operator operator;
    @CheckForNull
    private final String warningThreshold;
    @CheckForNull
    private final String errorThreshold;
    private final boolean onLeakPeriod;

    public Condition(String metricKey, Operator operator, @Nullable String errorThreshold, @Nullable String warningThreshold, boolean onLeakPeriod) {
        this.metricKey = Objects.requireNonNull(metricKey, "metricKey can't be null");
        this.operator = Objects.requireNonNull(operator, "operator can't be null");
        this.onLeakPeriod = onLeakPeriod;
        this.errorThreshold = Strings.emptyToNull((String)errorThreshold);
        this.warningThreshold = Strings.emptyToNull((String)warningThreshold);
    }

    public String getMetricKey() {
        return this.metricKey;
    }

    public boolean isOnLeakPeriod() {
        return this.onLeakPeriod;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Optional<String> getWarningThreshold() {
        return Optional.ofNullable(this.warningThreshold);
    }

    public Optional<String> getErrorThreshold() {
        return Optional.ofNullable(this.errorThreshold);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return this.onLeakPeriod == condition.onLeakPeriod && Objects.equals(this.metricKey, condition.metricKey) && this.operator == condition.operator && Objects.equals(this.warningThreshold, condition.warningThreshold) && Objects.equals(this.errorThreshold, condition.errorThreshold);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metricKey, this.operator, this.warningThreshold, this.errorThreshold, this.onLeakPeriod});
    }

    public String toString() {
        return "Condition{metricKey='" + this.metricKey + '\'' + ", operator=" + (Object)((Object)this.operator) + ", warningThreshold=" + Condition.toString(this.warningThreshold) + ", errorThreshold=" + Condition.toString(this.errorThreshold) + ", onLeakPeriod=" + this.onLeakPeriod + '}';
    }

    private static String toString(@Nullable String errorThreshold) {
        if (errorThreshold == null) {
            return null;
        }
        return '\'' + errorThreshold + '\'';
    }

    public static enum Operator {
        EQUALS("EQ"),
        NOT_EQUALS("NE"),
        GREATER_THAN("GT"),
        LESS_THAN("LT");

        private final String dbValue;

        private Operator(String dbValue) {
            this.dbValue = dbValue;
        }

        public String getDbValue() {
            return this.dbValue;
        }

        public static Operator fromDbValue(String s) {
            return Stream.of(Operator.values()).filter(o -> o.getDbValue().equals(s)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported operator db value: " + s));
        }
    }
}

