/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectlink.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ProjectLinkDto;
import org.sonar.server.projectlink.ws.ProjectLinksWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class DeleteAction
implements ProjectLinksWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;

    public DeleteAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete").setDescription("Delete existing project link.<br>Requires 'Administer' permission on the specified project, or global 'Administer' permission.").setHandler((RequestHandler)this).setPost(true).setSince("6.1");
        action.createParam("id").setRequired(true).setDescription("Link id").setExampleValue((Object)"17");
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(request.mandatoryParam("id"));
        response.noContent();
    }

    private void doHandle(String id) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ProjectLinkDto link = this.dbClient.projectLinkDao().selectByUuid(dbSession, id);
            link = WsUtils.checkFound(link, "Link with id '%s' not found", id);
            this.checkProjectAdminPermission(link);
            DeleteAction.checkNotProvided(link);
            this.dbClient.projectLinkDao().delete(dbSession, link.getUuid());
            dbSession.commit();
        }
    }

    private static void checkNotProvided(ProjectLinkDto link) {
        String type = link.getType();
        boolean isProvided = type != null && ProjectLinkDto.PROVIDED_TYPES.contains(type);
        WsUtils.checkRequest(!isProvided, "Provided link cannot be deleted.", new Object[0]);
    }

    private void checkProjectAdminPermission(ProjectLinkDto link) {
        this.userSession.checkComponentUuidPermission("admin", link.getProjectUuid());
    }
}

