/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.Protobuf;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.project.Visibility;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.project.ws.ProjectsWsSupport;
import org.sonar.server.project.ws.SearchRequest;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Projects;

public class SearchAction
implements ProjectsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ProjectsWsSupport support;

    public SearchAction(DbClient dbClient, UserSession userSession, ProjectsWsSupport support) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.support = support;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setSince("6.3").setDescription("Search for projects or views to administrate them.<br>Requires 'System Administrator' permission").addPagingParams(100, 500).setResponseExample(this.getClass().getResource("search-example.json")).setHandler((RequestHandler)this);
        action.setChangelog(new Change[]{new Change("6.4", "The 'uuid' field is deprecated in the response"), new Change("6.7.2", String.format("Parameters %s and %s accept maximum %d values", "projects", "projectIds", 1000))});
        action.createParam("q").setDescription("Limit search to: <ul><li>component names that contain the supplied string</li><li>component keys that contain the supplied string</li></ul>").setExampleValue((Object)"sonar");
        action.createParam("qualifiers").setDescription("Comma-separated list of component qualifiers. Filter the results with the specified qualifiers").setPossibleValues(new Object[]{"TRK", "VW", "APP"}).setDefaultValue((Object)"TRK");
        this.support.addOrganizationParam(action);
        action.createParam("visibility").setDescription("Filter the projects that should be visible to everyone (%s), or only specific user/groups (%s).<br/>If no visibility is specified, the default project visibility of the organization will be used.", new Object[]{Visibility.PUBLIC.getLabel(), Visibility.PRIVATE.getLabel()}).setRequired(false).setInternal(true).setSince("6.4").setPossibleValues(Visibility.getLabels());
        action.createParam("analyzedBefore").setDescription("Filter the projects for which last analysis is older than the given date (exclusive).<br> Either a date (server timezone) or datetime can be provided.").setSince("6.6").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("onProvisionedOnly").setDescription("Filter the projects that are provisioned").setBooleanPossibleValues().setDefaultValue((Object)"false").setSince("6.6");
        action.createParam("projects").setDescription("Comma-separated list of project keys").setSince("6.6").setMaxValuesAllowed(Integer.valueOf(1000)).setExampleValue((Object)String.join((CharSequence)",", "my_project", "another_project"));
        action.createParam("projectIds").setDescription("Comma-separated list of project ids").setSince("6.6").setDeprecatedSince("6.6").setMaxValuesAllowed(Integer.valueOf(1000)).setExampleValue((Object)String.join((CharSequence)",", "AU-Tpxb--iU5OvuD2FLy", "AU-TpxcA-iU5OvuD2FLz"));
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        Projects.SearchWsResponse searchWsResponse = this.doHandle(SearchAction.toSearchWsRequest(wsRequest));
        WsUtils.writeProtobuf((Message)searchWsResponse, wsRequest, wsResponse);
    }

    private static SearchRequest toSearchWsRequest(Request request) {
        return SearchRequest.builder().setOrganization(request.param("organization")).setQualifiers(request.mandatoryParamAsStrings("qualifiers")).setQuery(request.param("q")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setVisibility(request.param("visibility")).setAnalyzedBefore(request.param("analyzedBefore")).setOnProvisionedOnly(request.mandatoryParamAsBoolean("onProvisionedOnly")).setProjects(request.paramAsStrings("projects")).setProjectIds(request.paramAsStrings("projectIds")).build();
    }

    private Projects.SearchWsResponse doHandle(SearchRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.support.getOrganization(dbSession, request.getOrganization());
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            ComponentQuery query = SearchAction.buildDbQuery(request);
            Paging paging = this.buildPaging(dbSession, request, organization, query);
            List components = this.dbClient.componentDao().selectByQuery(dbSession, organization.getUuid(), query, paging.offset(), paging.pageSize());
            Map analysisDateByComponentUuid = (Map)this.dbClient.snapshotDao().selectLastAnalysesByRootComponentUuids(dbSession, (Collection)components.stream().map(ComponentDto::uuid).collect(MoreCollectors.toList())).stream().collect(MoreCollectors.uniqueIndex(SnapshotDto::getComponentUuid, SnapshotDto::getCreatedAt));
            Projects.SearchWsResponse searchWsResponse = SearchAction.buildResponse(components, organization, analysisDateByComponentUuid, paging);
            return searchWsResponse;
        }
    }

    static ComponentQuery buildDbQuery(SearchRequest request) {
        List<String> qualifiers = request.getQualifiers();
        ComponentQuery.Builder query = ComponentQuery.builder().setQualifiers(qualifiers.toArray(new String[qualifiers.size()]));
        Protobuf.setNullable((Object)request.getQuery(), q -> {
            query.setNameOrKeyQuery(q);
            query.setPartialMatchOnKey(Boolean.valueOf(true));
            return query;
        });
        Protobuf.setNullable((Object)request.getVisibility(), v -> query.setPrivate(Boolean.valueOf(Visibility.isPrivate(v))));
        Protobuf.setNullable((Object)request.getAnalyzedBefore(), d -> query.setAnalyzedBefore(Long.valueOf(DateUtils.parseDateOrDateTime((String)d).getTime())));
        Protobuf.setNullable((Object)request.isOnProvisionedOnly(), arg_0 -> ((ComponentQuery.Builder)query).setOnProvisionedOnly(arg_0));
        Protobuf.setNullable(request.getProjects(), keys -> query.setComponentKeys(new HashSet(keys)));
        Protobuf.setNullable(request.getProjectIds(), uuids -> query.setComponentUuids(new HashSet(uuids)));
        return query.build();
    }

    private Paging buildPaging(DbSession dbSession, SearchRequest request, OrganizationDto organization, ComponentQuery query) {
        int total = this.dbClient.componentDao().countByQuery(dbSession, organization.getUuid(), query);
        return Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal(total);
    }

    private static Projects.SearchWsResponse buildResponse(List<ComponentDto> components, OrganizationDto organization, Map<String, Long> analysisDateByComponentUuid, Paging paging) {
        Projects.SearchWsResponse.Builder responseBuilder = Projects.SearchWsResponse.newBuilder();
        responseBuilder.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        components.stream().map(dto -> SearchAction.dtoToProject(organization, dto, (Long)analysisDateByComponentUuid.get(dto.uuid()))).forEach(arg_0 -> ((Projects.SearchWsResponse.Builder)responseBuilder).addComponents(arg_0));
        return responseBuilder.build();
    }

    private static Projects.SearchWsResponse.Component dtoToProject(OrganizationDto organization, ComponentDto dto, @Nullable Long analysisDate) {
        Preconditions.checkArgument((boolean)organization.getUuid().equals(dto.getOrganizationUuid()), (String)"No Organization found for uuid '%s'", (Object[])new Object[]{dto.getOrganizationUuid()});
        Projects.SearchWsResponse.Component.Builder builder = Projects.SearchWsResponse.Component.newBuilder().setOrganization(organization.getKey()).setId(dto.uuid()).setKey(dto.getDbKey()).setName(dto.name()).setQualifier(dto.qualifier()).setVisibility(dto.isPrivate() ? Visibility.PRIVATE.getLabel() : Visibility.PUBLIC.getLabel());
        Protobuf.setNullable((Object)analysisDate, d -> builder.setLastAnalysisDate(DateUtils.formatDateTime((long)d)));
        return builder.build();
    }
}

