/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.sonar.core.platform.PluginInfo;

@Immutable
public class InstalledPlugin {
    private final PluginInfo plugin;
    private final FileAndMd5 loadedJar;
    @Nullable
    private final FileAndMd5 compressedJar;

    public InstalledPlugin(PluginInfo plugin, FileAndMd5 loadedJar, @Nullable FileAndMd5 compressedJar) {
        this.plugin = Objects.requireNonNull(plugin);
        this.loadedJar = Objects.requireNonNull(loadedJar);
        this.compressedJar = compressedJar;
    }

    public PluginInfo getPluginInfo() {
        return this.plugin;
    }

    public FileAndMd5 getLoadedJar() {
        return this.loadedJar;
    }

    @Nullable
    public FileAndMd5 getCompressedJar() {
        return this.compressedJar;
    }

    @Immutable
    public static final class FileAndMd5 {
        private final File file;
        private final String md5;

        public FileAndMd5(File file) {
            try (FileInputStream fis = FileUtils.openInputStream((File)file);){
                this.file = file;
                this.md5 = DigestUtils.md5Hex((InputStream)fis);
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to compute md5 of " + file, e);
            }
        }

        public File getFile() {
            return this.file;
        }

        public String getMd5() {
            return this.md5;
        }
    }
}

