/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityServletFilter
implements Filter {
    private static final Set<String> ALLOWED_HTTP_METHODS = ImmutableSet.of((Object)"DELETE", (Object)"GET", (Object)"HEAD", (Object)"POST", (Object)"PUT");

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        SecurityServletFilter.doHttpFilter((HttpServletRequest)req, (HttpServletResponse)resp, chain);
    }

    private static void doHttpFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
        if (!ALLOWED_HTTP_METHODS.contains(httpRequest.getMethod())) {
            httpResponse.setStatus(405);
            return;
        }
        String path = httpRequest.getRequestURI().replaceFirst(httpRequest.getContextPath(), "");
        if (!path.startsWith("/integration/")) {
            httpResponse.addHeader("X-Frame-Options", "SAMEORIGIN");
        }
        httpResponse.addHeader("X-XSS-Protection", "1; mode=block");
        httpResponse.addHeader("X-Content-Type-Options", "nosniff");
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }
}

