/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.platformlevel;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.core.platform.Module;
import org.sonar.server.platform.WebServer;

public abstract class PlatformLevel {
    private final String name;
    @Nullable
    private final PlatformLevel parent;
    private final ComponentContainer container;
    private AddIfStartupLeader addIfStartupLeader;
    private AddIfCluster addIfCluster;
    private AddIfStandalone addIfStandalone;

    public PlatformLevel(String name) {
        this.name = name;
        this.parent = null;
        this.container = this.createContainer(null);
    }

    public PlatformLevel(String name, @Nonnull PlatformLevel parent) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.parent = (PlatformLevel)Preconditions.checkNotNull((Object)parent);
        this.container = this.createContainer(parent.container);
    }

    public ComponentContainer getContainer() {
        return this.container;
    }

    public String getName() {
        return this.name;
    }

    protected ComponentContainer createContainer(@Nullable ComponentContainer parent) {
        if (parent == null) {
            return new ComponentContainer();
        }
        return parent.createChild();
    }

    public PlatformLevel configure() {
        this.configureLevel();
        List modules = this.container.getComponentsByType(Module.class);
        for (Module module : modules) {
            module.configure(this.container);
        }
        return this;
    }

    protected abstract void configureLevel();

    public PlatformLevel start() {
        this.container.startComponents();
        return this;
    }

    public PlatformLevel stop() {
        this.container.stopComponents();
        return this;
    }

    public PlatformLevel destroy() {
        if (this.parent != null) {
            this.parent.container.removeChild(this.container);
        }
        return this;
    }

    protected <T> T get(Class<T> tClass) {
        return (T)Objects.requireNonNull(this.container.getComponentByType(tClass));
    }

    protected <T> List<T> getAll(Class<T> tClass) {
        return this.container.getComponentsByType(tClass);
    }

    protected <T> Optional<T> getOptional(Class<T> tClass) {
        return Optional.ofNullable(this.container.getComponentByType(tClass));
    }

    protected void add(Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            this.container.addComponent(object, true);
        }
    }

    AddIfStartupLeader addIfStartupLeader(Object ... objects) {
        if (this.addIfStartupLeader == null) {
            this.addIfStartupLeader = new AddIfStartupLeader(this.getWebServer().isStartupLeader());
        }
        this.addIfStartupLeader.ifAdd(objects);
        return this.addIfStartupLeader;
    }

    AddIfCluster addIfCluster(Object ... objects) {
        if (this.addIfCluster == null) {
            this.addIfCluster = new AddIfCluster(!this.getWebServer().isStandalone());
        }
        this.addIfCluster.ifAdd(objects);
        return this.addIfCluster;
    }

    AddIfStandalone addIfStandalone(Object ... objects) {
        if (this.addIfStandalone == null) {
            this.addIfStandalone = new AddIfStandalone(this.getWebServer().isStandalone());
        }
        this.addIfStandalone.ifAdd(objects);
        return this.addIfStandalone;
    }

    private WebServer getWebServer() {
        return this.getOptional(WebServer.class).orElseThrow(() -> new IllegalStateException("WebServer not available in Pico yet"));
    }

    protected void addAll(Collection<?> objects) {
        this.add(objects.toArray(new Object[objects.size()]));
    }

    public final class AddIfStandalone
    extends AddIf {
        private AddIfStandalone(boolean condition) {
            super(condition);
        }
    }

    public final class AddIfCluster
    extends AddIf {
        private AddIfCluster(boolean condition) {
            super(condition);
        }
    }

    public final class AddIfStartupLeader
    extends AddIf {
        private AddIfStartupLeader(boolean condition) {
            super(condition);
        }
    }

    private abstract class AddIf {
        private final boolean condition;

        private AddIf(boolean condition) {
            this.condition = condition;
        }

        public void ifAdd(Object ... objects) {
            if (this.condition) {
                PlatformLevel.this.add(objects);
            }
        }

        public void otherwiseAdd(Object ... objects) {
            if (!this.condition) {
                PlatformLevel.this.add(objects);
            }
        }
    }
}

