/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.systeminfo.Global;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.es.EsClient;

@ServerSide
public class EsIndexesSection
implements SystemInfoSection,
Global {
    private final EsClient esClient;

    public EsIndexesSection(EsClient esClient) {
        this.esClient = esClient;
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("Search Indexes");
        try {
            this.completeIndexAttributes(protobuf);
        }
        catch (Exception es) {
            Loggers.get(EsIndexesSection.class).warn("Failed to retrieve ES attributes. There will be only a single \"Error\" attribute.", (Throwable)es);
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Error", (String)(es.getCause() instanceof ElasticsearchException ? es.getCause().getMessage() : es.getMessage()));
        }
        return protobuf.build();
    }

    private void completeIndexAttributes(ProtobufSystemInfo.Section.Builder protobuf) {
        IndicesStatsResponse indicesStats = (IndicesStatsResponse)this.esClient.prepareStats(new String[0]).all().get();
        for (Map.Entry indexStats : indicesStats.getIndices().entrySet()) {
            String prefix = "Index " + (String)indexStats.getKey() + " - ";
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)(prefix + "Docs"), (long)((IndexStats)indexStats.getValue()).getPrimaries().getDocs().getCount());
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)(prefix + "Shards"), (long)((IndexStats)indexStats.getValue()).getShards().length);
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)(prefix + "Store Size"), (String)FileUtils.byteCountToDisplaySize((long)((IndexStats)indexStats.getValue()).getPrimaries().getStore().getSizeInBytes()));
        }
    }
}

