/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.UserId;
import org.sonar.server.permission.ws.PermissionRequestValidator;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;

public class RemoveUserFromTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final UserSession userSession;

    public RemoveUserFromTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, UserSession userSession) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
    }

    private static RemoveUserFromTemplateRequest toRemoveUserFromTemplateWsRequest(Request request) {
        return new RemoveUserFromTemplateRequest().setPermission(request.mandatoryParam("permission")).setLogin(request.mandatoryParam("login")).setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName"));
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove_user_from_template").setPost(true).setSince("5.2").setDescription("Remove a user from a permission template.<br /> Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action);
        PermissionsWsParametersBuilder.createUserLoginParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(RemoveUserFromTemplateAction.toRemoveUserFromTemplateWsRequest(request));
        response.noContent();
    }

    private void doHandle(RemoveUserFromTemplateRequest request) {
        String permission = request.getPermission();
        String userLogin = request.getLogin();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionRequestValidator.validateProjectPermission(permission);
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            UserId user = this.wsSupport.findUser(dbSession, userLogin);
            this.dbClient.permissionTemplateDao().deleteUserPermission(dbSession, template.getId(), Integer.valueOf(user.getId()), permission);
            dbSession.commit();
        }
    }

    private static class RemoveUserFromTemplateRequest {
        private String login;
        private String permission;
        private String templateId;
        private String organization;
        private String templateName;

        private RemoveUserFromTemplateRequest() {
        }

        public String getLogin() {
            return this.login;
        }

        public RemoveUserFromTemplateRequest setLogin(String login) {
            this.login = Objects.requireNonNull(login);
            return this;
        }

        public String getPermission() {
            return this.permission;
        }

        public RemoveUserFromTemplateRequest setPermission(String permission) {
            this.permission = Objects.requireNonNull(permission);
            return this;
        }

        @CheckForNull
        public String getTemplateId() {
            return this.templateId;
        }

        public RemoveUserFromTemplateRequest setTemplateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        public RemoveUserFromTemplateRequest setOrganization(@Nullable String s) {
            this.organization = s;
            return this;
        }

        @CheckForNull
        public String getTemplateName() {
            return this.templateName;
        }

        public RemoveUserFromTemplateRequest setTemplateName(@Nullable String templateName) {
            this.templateName = templateName;
            return this;
        }
    }
}

