/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.UserId;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;

public class AddUserToTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final UserSession userSession;

    public AddUserToTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, UserSession userSession) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
    }

    private static AddUserToTemplateRequest toAddUserToTemplateWsRequest(Request request) {
        return new AddUserToTemplateRequest().setLogin(request.mandatoryParam("login")).setPermission(request.mandatoryParam("permission")).setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName"));
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_user_to_template").setPost(true).setSince("5.2").setDescription("Add a user to a permission template.<br /> Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action);
        PermissionsWsParametersBuilder.createUserLoginParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(AddUserToTemplateAction.toAddUserToTemplateWsRequest(request));
        response.noContent();
    }

    private void doHandle(AddUserToTemplateRequest request) {
        String permission = request.getPermission();
        String userLogin = request.getLogin();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            OrganizationDto organizationDto = this.wsSupport.findOrganization(dbSession, request.getOrganization());
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, organizationDto.getUuid());
            UserId user = this.wsSupport.findUser(dbSession, userLogin);
            this.wsSupport.checkMembership(dbSession, organizationDto, user);
            if (!this.isUserAlreadyAdded(dbSession, organizationDto, template.getId(), userLogin, permission)) {
                this.dbClient.permissionTemplateDao().insertUserPermission(dbSession, template.getId(), Integer.valueOf(user.getId()), permission);
                dbSession.commit();
            }
        }
    }

    private boolean isUserAlreadyAdded(DbSession dbSession, OrganizationDto organizationDto, long templateId, String userLogin, String permission) {
        PermissionQuery permissionQuery = PermissionQuery.builder().setOrganizationUuid(organizationDto.getUuid()).setPermission(permission).build();
        List usersWithPermission = this.dbClient.permissionTemplateDao().selectUserLoginsByQueryAndTemplate(dbSession, permissionQuery, templateId);
        return usersWithPermission.stream().anyMatch(s -> s.equals(userLogin));
    }

    private static class AddUserToTemplateRequest {
        private String login;
        private String permission;
        private String templateId;
        private String organization;
        private String templateName;

        private AddUserToTemplateRequest() {
        }

        public String getLogin() {
            return this.login;
        }

        public AddUserToTemplateRequest setLogin(String login) {
            this.login = Objects.requireNonNull(login);
            return this;
        }

        public String getPermission() {
            return this.permission;
        }

        public AddUserToTemplateRequest setPermission(String permission) {
            this.permission = Objects.requireNonNull(permission);
            return this;
        }

        @CheckForNull
        public String getTemplateId() {
            return this.templateId;
        }

        public AddUserToTemplateRequest setTemplateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        @CheckForNull
        public String getTemplateName() {
            return this.templateName;
        }

        public AddUserToTemplateRequest setTemplateName(@Nullable String templateName) {
            this.templateName = templateName;
            return this;
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        public AddUserToTemplateRequest setOrganization(@Nullable String s) {
            this.organization = s;
            return this;
        }
    }
}

