/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import java.util.Collections;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.index.UserIndexer;
import org.sonar.server.ws.WsUtils;

public class RemoveMemberAction
implements OrganizationsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final UserIndexer userIndexer;

    public RemoveMemberAction(DbClient dbClient, UserSession userSession, UserIndexer userIndexer) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.userIndexer = userIndexer;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove_member").setDescription("Remove a member from an organization.<br>Requires 'Administer System' permission on the specified organization.").setSince("6.4").setPost(true).setInternal(true).setHandler((RequestHandler)this);
        action.createParam("organization").setDescription("Organization key").setRequired(true).setExampleValue((Object)"my-org");
        action.createParam("login").setDescription("User login").setRequired(true).setExampleValue((Object)"ray.bradbury");
    }

    public void handle(Request request, Response response) throws Exception {
        String organizationKey = request.mandatoryParam("organization");
        String login = request.mandatoryParam("login");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "Organization '%s' is not found", organizationKey);
            UserDto user = WsUtils.checkFound(this.dbClient.userDao().selectActiveUserByLogin(dbSession, login), "User '%s' is not found", login);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER, organization);
            this.dbClient.organizationMemberDao().select(dbSession, organization.getUuid(), user.getId().intValue()).ifPresent(om -> this.removeMember(dbSession, organization, user));
        }
        response.noContent();
    }

    private void removeMember(DbSession dbSession, OrganizationDto organization, UserDto user) {
        this.ensureLastAdminIsNotRemoved(dbSession, organization, user);
        int userId = user.getId();
        String organizationUuid = organization.getUuid();
        this.dbClient.userPermissionDao().deleteOrganizationMemberPermissions(dbSession, organizationUuid, userId);
        this.dbClient.permissionTemplateDao().deleteUserPermissionsByOrganization(dbSession, organizationUuid, userId);
        this.dbClient.qProfileEditUsersDao().deleteByOrganizationAndUser(dbSession, organization, user);
        this.dbClient.userGroupDao().deleteByOrganizationAndUser(dbSession, organizationUuid, userId);
        this.dbClient.propertiesDao().deleteByOrganizationAndUser(dbSession, organizationUuid, userId);
        this.dbClient.propertiesDao().deleteByOrganizationAndMatchingLogin(dbSession, organizationUuid, user.getLogin(), Collections.singletonList("sonar.issues.defaultAssigneeLogin"));
        this.dbClient.organizationMemberDao().delete(dbSession, organizationUuid, Integer.valueOf(userId));
        this.userIndexer.commitAndIndex(dbSession, user);
    }

    private void ensureLastAdminIsNotRemoved(DbSession dbSession, OrganizationDto organizationDto, UserDto user) {
        int remainingAdmins = this.dbClient.authorizationDao().countUsersWithGlobalPermissionExcludingUser(dbSession, organizationDto.getUuid(), OrganizationPermission.ADMINISTER.getKey(), user.getId().intValue());
        WsUtils.checkRequest(remainingAdmins > 0, "The last administrator member cannot be removed", new Object[0]);
    }
}

