/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.metric.ws;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.metric.ws.MetricJsonWriter;
import org.sonar.server.metric.ws.MetricsWsAction;

public class SearchAction
implements MetricsWsAction {
    private static final String ACTION = "search";
    public static final String PARAM_IS_CUSTOM = "isCustom";
    private final Set<String> allPossibleFields;
    private final DbClient dbClient;

    public SearchAction(DbClient dbClient) {
        this.dbClient = dbClient;
        HashSet possibleFields = Sets.newHashSet((Object[])new String[]{"id", "key"});
        possibleFields.addAll(MetricJsonWriter.OPTIONAL_FIELDS);
        this.allPossibleFields = possibleFields;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setSince("5.2").setDescription("Search for metrics").setResponseExample(this.getClass().getResource("example-search.json")).addPagingParams(100, 500).addFieldsParam(MetricJsonWriter.OPTIONAL_FIELDS).setHandler((RequestHandler)this);
        action.createParam(PARAM_IS_CUSTOM).setExampleValue((Object)"true").setDescription("Choose custom metrics following 3 cases:<ul><li>true: only custom metrics are returned</li><li>false: only non custom metrics are returned</li><li>not specified: all metrics are returned</li></ul>");
    }

    public void handle(Request request, Response response) throws Exception {
        SearchOptions searchOptions = new SearchOptions().setPage(request.mandatoryParamAsInt("p"), request.mandatoryParamAsInt("ps"));
        Boolean isCustom = request.paramAsBoolean(PARAM_IS_CUSTOM);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List metrics = this.dbClient.metricDao().selectEnabled(dbSession, isCustom, searchOptions.getOffset(), searchOptions.getLimit());
            int nbMetrics = this.dbClient.metricDao().countEnabled(dbSession, isCustom);
            JsonWriter json = response.newJsonWriter();
            json.beginObject();
            Set<String> desiredFields = this.desiredFields(request.paramAsStrings("f"));
            SearchAction.writeMetrics(json, metrics, desiredFields);
            searchOptions.writeJson(json, nbMetrics);
            json.endObject();
            json.close();
        }
    }

    private Set<String> desiredFields(@Nullable List<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return this.allPossibleFields;
        }
        return Sets.newHashSet(fields);
    }

    public static void writeMetrics(JsonWriter json, List<MetricDto> metrics, Set<String> desiredFields) {
        MetricJsonWriter.write(json, metrics, desiredFields);
    }
}

