/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.metric.ws;

import java.util.List;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.metric.ws.MetricsWsAction;

public class DomainsAction
implements MetricsWsAction {
    private final DbClient dbClient;

    public DomainsAction(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController context) {
        context.createAction("domains").setDescription("List all custom metric domains.").setSince("5.2").setResponseExample(this.getClass().getResource("example-domains.json")).setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List domains = this.dbClient.metricDao().selectEnabledDomains(dbSession);
            JsonWriter json = response.newJsonWriter();
            json.beginObject();
            DomainsAction.writeDomains(json, domains);
            json.endObject();
            json.close();
        }
    }

    private static void writeDomains(JsonWriter json, List<String> domains) {
        json.name("domains");
        json.beginArray();
        json.values(domains);
        json.endArray();
    }
}

