/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import org.sonar.core.util.Protobuf;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureValueFormatter;
import org.sonarqube.ws.Common;

class MetricDtoToWsMetric {
    private MetricDtoToWsMetric() {
    }

    static Common.Metric metricDtoToWsMetric(MetricDto metricDto) {
        Common.Metric.Builder metric = Common.Metric.newBuilder();
        metric.setKey(metricDto.getKey());
        metric.setType(metricDto.getValueType());
        metric.setName(metricDto.getShortName());
        Protobuf.setNullable((Object)metricDto.getDescription(), arg_0 -> ((Common.Metric.Builder)metric).setDescription(arg_0));
        Protobuf.setNullable((Object)metricDto.getDomain(), arg_0 -> ((Common.Metric.Builder)metric).setDomain(arg_0));
        if (metricDto.getDirection() != 0) {
            metric.setHigherValuesAreBetter(metricDto.getDirection() > 0);
        }
        metric.setQualitative(metricDto.isQualitative());
        metric.setHidden(metricDto.isHidden());
        metric.setCustom(metricDto.isUserManaged());
        Protobuf.setNullable((Object)metricDto.getDecimalScale(), arg_0 -> ((Common.Metric.Builder)metric).setDecimalScale(arg_0));
        Protobuf.setNullable((Object)metricDto.getBestValue(), bv -> metric.setBestValue(MeasureValueFormatter.formatNumericalValue(bv, metricDto)));
        Protobuf.setNullable((Object)metricDto.getWorstValue(), wv -> metric.setWorstValue(MeasureValueFormatter.formatNumericalValue(wv, metricDto)));
        return metric.build();
    }
}

