/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.custom.ws;

import org.sonar.api.PropertyType;
import org.sonar.api.measures.Metric;
import org.sonar.api.server.ServerSide;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.util.TypeValidations;

@ServerSide
public class CustomMeasureValidator {
    private final TypeValidations typeValidations;

    public CustomMeasureValidator(TypeValidations typeValidations) {
        this.typeValidations = typeValidations;
    }

    public void setMeasureValue(CustomMeasureDto measure, String valueAsString, MetricDto metric) {
        Metric.ValueType metricType = Metric.ValueType.valueOf((String)metric.getValueType());
        switch (metricType) {
            case BOOL: {
                this.checkAndSetBooleanMeasureValue(measure, valueAsString);
                break;
            }
            case INT: 
            case MILLISEC: {
                this.checkAndSetIntegerMeasureValue(measure, valueAsString);
                break;
            }
            case WORK_DUR: {
                this.checkAndSetLongMeasureValue(measure, valueAsString);
                break;
            }
            case FLOAT: 
            case PERCENT: 
            case RATING: {
                this.checkAndSetFloatMeasureValue(measure, valueAsString);
                break;
            }
            case LEVEL: {
                this.checkAndSetLevelMeasureValue(measure, valueAsString);
                break;
            }
            case STRING: 
            case DATA: 
            case DISTRIB: {
                measure.setTextValue(valueAsString);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metric type:" + metricType.name());
            }
        }
    }

    private void checkAndSetLevelMeasureValue(CustomMeasureDto measure, String valueAsString) {
        this.typeValidations.validate(valueAsString, PropertyType.METRIC_LEVEL.name(), null);
        measure.setTextValue(valueAsString);
    }

    private void checkAndSetFloatMeasureValue(CustomMeasureDto measure, String valueAsString) {
        this.typeValidations.validate(valueAsString, PropertyType.FLOAT.name(), null);
        measure.setValue(Double.parseDouble(valueAsString));
    }

    private void checkAndSetLongMeasureValue(CustomMeasureDto measure, String valueAsString) {
        this.typeValidations.validate(valueAsString, PropertyType.LONG.name(), null);
        measure.setValue((double)Long.parseLong(valueAsString));
    }

    private void checkAndSetIntegerMeasureValue(CustomMeasureDto measure, String valueAsString) {
        this.typeValidations.validate(valueAsString, PropertyType.INTEGER.name(), null);
        measure.setValue((double)Integer.parseInt(valueAsString));
    }

    private void checkAndSetBooleanMeasureValue(CustomMeasureDto measure, String valueAsString) {
        this.typeValidations.validate(valueAsString, PropertyType.BOOLEAN.name(), null);
        measure.setValue(Boolean.parseBoolean(valueAsString) ? 1.0 : 0.0);
    }

    public static void checkPermissions(UserSession userSession, ComponentDto component) {
        userSession.checkLoggedIn().checkComponentPermission("admin", component);
    }
}

