/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.custom.ws;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.metric.ws.MetricJsonWriter;
import org.sonar.server.user.ws.UserJsonWriter;
import org.sonar.server.ws.JsonWriterUtils;

public class CustomMeasureJsonWriter {
    private static final String FIELD_ID = "id";
    private static final String FIELD_PROJECT_ID = "projectId";
    private static final String FIELD_PROJECT_KEY = "projectKey";
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_METRIC = "metric";
    private static final String FIELD_CREATED_AT = "createdAt";
    private static final String FIELD_UPDATED_AT = "updatedAt";
    private static final String FIELD_USER = "user";
    private static final String FIELD_PENDING = "pending";
    public static final Set<String> OPTIONAL_FIELDS = ImmutableSet.of((Object)"projectId", (Object)"projectKey", (Object)"value", (Object)"description", (Object)"metric", (Object)"createdAt", (Object[])new String[]{"updatedAt", "user", "pending"});
    private final UserJsonWriter userJsonWriter;

    public CustomMeasureJsonWriter(UserJsonWriter userJsonWriter) {
        this.userJsonWriter = userJsonWriter;
    }

    public void write(JsonWriter json, CustomMeasureDto measure, MetricDto metric, ComponentDto component, UserDto user, boolean isPending, @Nullable Collection<String> fieldsToReturn) {
        json.beginObject();
        json.prop(FIELD_ID, String.valueOf(measure.getId()));
        JsonWriterUtils.writeIfNeeded(json, this.measureValue(measure, metric), FIELD_VALUE, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, measure.getDescription(), FIELD_DESCRIPTION, fieldsToReturn);
        if (JsonWriterUtils.isFieldNeeded(FIELD_METRIC, fieldsToReturn)) {
            json.name(FIELD_METRIC);
            MetricJsonWriter.write(json, metric, MetricJsonWriter.MANDATORY_FIELDS);
        }
        JsonWriterUtils.writeIfNeeded(json, component.uuid(), FIELD_PROJECT_ID, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, component.getDbKey(), FIELD_PROJECT_KEY, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, new Date(measure.getCreatedAt()), FIELD_CREATED_AT, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, new Date(measure.getUpdatedAt()), FIELD_UPDATED_AT, fieldsToReturn);
        JsonWriterUtils.writeIfNeeded(json, isPending, FIELD_PENDING, fieldsToReturn);
        if (JsonWriterUtils.isFieldNeeded(FIELD_USER, fieldsToReturn)) {
            json.name(FIELD_USER);
            this.userJsonWriter.write(json, user);
        }
        json.endObject();
    }

    private String measureValue(CustomMeasureDto measure, MetricDto metric) {
        Metric.ValueType metricType = Metric.ValueType.valueOf((String)metric.getValueType());
        Double doubleValue = measure.getValue();
        String stringValue = measure.getTextValue();
        switch (metricType) {
            case BOOL: {
                return doubleValue == 1.0 ? "true" : "false";
            }
            case INT: 
            case MILLISEC: {
                return String.valueOf(doubleValue.intValue());
            }
            case WORK_DUR: {
                return String.valueOf(doubleValue.longValue());
            }
            case FLOAT: 
            case PERCENT: 
            case RATING: {
                return String.valueOf(doubleValue);
            }
            case LEVEL: 
            case STRING: 
            case DATA: 
            case DISTRIB: {
                return stringValue;
            }
        }
        throw new IllegalArgumentException("Unsupported metric type: " + metricType.name());
    }
}

