/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.workflow.Transition;

public class SearchResponseData {
    private final List<IssueDto> issues;
    private Long effortTotal = null;
    private final Map<String, UserDto> usersByUuid = new HashMap<String, UserDto>();
    private List<RuleDefinitionDto> rules = null;
    private final Map<String, String> organizationKeysByUuid = new HashMap<String, String>();
    private final Map<String, ComponentDto> componentsByUuid = new HashMap<String, ComponentDto>();
    private final ListMultimap<String, IssueChangeDto> commentsByIssueKey = ArrayListMultimap.create();
    private final ListMultimap<String, String> actionsByIssueKey = ArrayListMultimap.create();
    private final ListMultimap<String, Transition> transitionsByIssueKey = ArrayListMultimap.create();
    private final Set<String> updatableComments = new HashSet<String>();

    public SearchResponseData(IssueDto issue) {
        Preconditions.checkNotNull((Object)issue);
        this.issues = ImmutableList.of((Object)issue);
    }

    public SearchResponseData(List<IssueDto> issues) {
        Preconditions.checkNotNull(issues);
        this.issues = issues;
    }

    public List<IssueDto> getIssues() {
        return this.issues;
    }

    public Collection<ComponentDto> getComponents() {
        return this.componentsByUuid.values();
    }

    @CheckForNull
    public ComponentDto getComponentByUuid(String uuid) {
        return this.componentsByUuid.get(uuid);
    }

    public List<UserDto> getUsers() {
        return new ArrayList<UserDto>(this.usersByUuid.values());
    }

    @CheckForNull
    public List<RuleDefinitionDto> getRules() {
        return this.rules;
    }

    public String getOrganizationKey(String organizationUuid) {
        String organizationKey = this.organizationKeysByUuid.get(organizationUuid);
        Preconditions.checkNotNull((Object)organizationKey, (String)"Organization for uuid '%s' not found", (Object[])new Object[]{organizationUuid});
        return organizationKey;
    }

    @CheckForNull
    public List<IssueChangeDto> getCommentsForIssueKey(String issueKey) {
        if (this.commentsByIssueKey.containsKey((Object)issueKey)) {
            return this.commentsByIssueKey.get((Object)issueKey);
        }
        return null;
    }

    @CheckForNull
    public List<String> getActionsForIssueKey(String issueKey) {
        if (this.actionsByIssueKey.containsKey((Object)issueKey)) {
            return this.actionsByIssueKey.get((Object)issueKey);
        }
        return null;
    }

    @CheckForNull
    public List<Transition> getTransitionsForIssueKey(String issueKey) {
        if (this.transitionsByIssueKey.containsKey((Object)issueKey)) {
            return this.transitionsByIssueKey.get((Object)issueKey);
        }
        return null;
    }

    public void addUsers(@Nullable List<UserDto> users) {
        if (users != null) {
            users.forEach(u -> this.usersByUuid.put(u.getUuid(), (UserDto)u));
        }
    }

    public void setRules(@Nullable List<RuleDefinitionDto> rules) {
        this.rules = rules;
    }

    public void setComments(@Nullable List<IssueChangeDto> comments) {
        for (IssueChangeDto comment : comments) {
            this.commentsByIssueKey.put((Object)comment.getIssueKey(), (Object)comment);
        }
    }

    public void addComponents(@Nullable Collection<ComponentDto> dtos) {
        if (dtos != null) {
            for (ComponentDto dto : dtos) {
                this.componentsByUuid.put(dto.uuid(), dto);
            }
        }
    }

    public void addActions(String issueKey, List<String> actions) {
        this.actionsByIssueKey.putAll((Object)issueKey, actions);
    }

    public void addTransitions(String issueKey, List<Transition> transitions) {
        this.transitionsByIssueKey.putAll((Object)issueKey, transitions);
    }

    public void addUpdatableComment(String commentKey) {
        this.updatableComments.add(commentKey);
    }

    public boolean isUpdatableComment(String commentKey) {
        return this.updatableComments.contains(commentKey);
    }

    @CheckForNull
    public Long getEffortTotal() {
        return this.effortTotal;
    }

    public void setEffortTotal(@Nullable Long effortTotal) {
        this.effortTotal = effortTotal;
    }

    public void addOrganization(OrganizationDto organizationDto) {
        this.organizationKeysByUuid.put(organizationDto.getUuid(), organizationDto.getKey());
    }

    @CheckForNull
    public UserDto getUserByUuid(@Nullable String userUuid) {
        UserDto userDto = this.usersByUuid.get(userUuid);
        if (userDto == null) {
            return null;
        }
        return userDto;
    }
}

