/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.sonar.api.issue.Issue;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.es.Facets;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.issue.IssueQuery;
import org.sonar.server.issue.IssueQueryFactory;
import org.sonar.server.issue.SearchRequest;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.SearchAdditionalField;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.issue.ws.SearchResponseFormat;
import org.sonar.server.issue.ws.SearchResponseLoader;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Issues;

public class SearchAction
implements IssuesWsAction {
    public static final String LOGIN_MYSELF = "__me__";
    private static final String INTERNAL_PARAMETER_DISCLAIMER = "This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. ";
    private static final Set<String> IGNORED_FACETS = Sets.newHashSet((Object[])new String[]{"planned", "actionPlans", "reporters"});
    private static final Set<String> FACETS_REQUIRING_PROJECT_OR_ORGANIZATION = Sets.newHashSet((Object[])new String[]{"fileUuids", "directories", "moduleUuids"});
    private static final Joiner COMA_JOINER = Joiner.on((String)",");
    private static final Logger LOGGER = Loggers.get(SearchAction.class);
    private final UserSession userSession;
    private final IssueIndex issueIndex;
    private final IssueQueryFactory issueQueryFactory;
    private final SearchResponseLoader searchResponseLoader;
    private final SearchResponseFormat searchResponseFormat;
    private final System2 system2;
    private final DbClient dbClient;

    public SearchAction(UserSession userSession, IssueIndex issueIndex, IssueQueryFactory issueQueryFactory, SearchResponseLoader searchResponseLoader, SearchResponseFormat searchResponseFormat, System2 system2, DbClient dbClient) {
        this.userSession = userSession;
        this.issueIndex = issueIndex;
        this.issueQueryFactory = issueQueryFactory;
        this.searchResponseLoader = searchResponseLoader;
        this.searchResponseFormat = searchResponseFormat;
        this.system2 = system2;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("search").setHandler((RequestHandler)this).setDescription("Search for issues.<br>At most one of the following parameters can be provided at the same time: %s, %s, %s, %s, %s.<br>Requires the 'Browse' permission on the specified project(s).", new Object[]{"componentKeys", "componentUuids", "components", "componentRootUuids", "componentRoots"}).setSince("3.6").setChangelog(new Change[]{new Change("6.5", "parameters 'projects', 'projectUuids', 'moduleUuids', 'directories', 'fileUuids' are marked as internal"), new Change("6.3", "response field 'email' is renamed 'avatar'"), new Change("5.5", "response fields 'reporter' and 'actionPlan' are removed (drop of action plan and manual issue features)"), new Change("5.5", "parameters 'reporters', 'actionPlans' and 'planned' are dropped and therefore ignored (drop of action plan and manual issue features)"), new Change("5.5", "response field 'debt' is renamed 'effort'"), new Change("7.2", "response field 'externalRuleEngine' added to issues that have been imported from an external rule engine"), new Change("7.2", String.format("value '%s' in parameter '%s' is deprecated, it won't have any effect", "ASSIGNEE", "s"))}).setResponseExample(this.getClass().getResource("search-example.json"));
        action.addPagingParams(100, 500);
        action.createParam("facets").setDescription("Comma-separated list of the facets to be computed. No facet is computed by default.<br/>Since 5.5, facet 'actionPlans' is deprecated.<br/>Since 5.5, facet 'reporters' is deprecated.").setPossibleValues(IssueIndex.SUPPORTED_FACETS);
        action.createParam("facetMode").setDefaultValue((Object)"count").setDescription("Choose the returned value for facet items, either count of issues or sum of debt.<br/>Since 5.5, 'debt' mode is deprecated and replaced by 'effort'").setPossibleValues(new Object[]{"count", "effort", "debt"});
        action.addSortParams(IssueQuery.SORTS, null, true);
        action.createParam("additionalFields").setSince("5.2").setDescription("Comma-separated list of the optional fields to be returned in response. Action plans are dropped in 5.5, it is not returned in the response.").setPossibleValues(SearchAdditionalField.possibleValues());
        SearchAction.addComponentRelatedParams(action);
        action.createParam("issues").setDescription("Comma-separated list of issue keys").setExampleValue((Object)"5bccd6e8-f525-43a2-8d76-fcb13dde79ef");
        action.createParam("severities").setDescription("Comma-separated list of severities").setExampleValue((Object)"BLOCKER,CRITICAL").setPossibleValues((Collection)Severity.ALL);
        action.createParam("statuses").setDescription("Comma-separated list of statuses").setExampleValue((Object)"OPEN,REOPENED").setPossibleValues((Collection)Issue.STATUSES);
        action.createParam("resolutions").setDescription("Comma-separated list of resolutions").setExampleValue((Object)"FIXED,REMOVED").setPossibleValues((Collection)Issue.RESOLUTIONS);
        action.createParam("resolved").setDescription("To match resolved or unresolved issues").setBooleanPossibleValues();
        action.createParam("rules").setDescription("Comma-separated list of coding rule keys. Format is &lt;repository&gt;:&lt;rule&gt;").setExampleValue((Object)"squid:AvoidCycles");
        action.createParam("tags").setDescription("Comma-separated list of tags.").setExampleValue((Object)"security,convention");
        action.createParam("types").setDescription("Comma-separated list of types.").setSince("5.5").setPossibleValues((Object[])RuleType.values()).setExampleValue((Object)String.format("%s,%s", RuleType.CODE_SMELL, RuleType.BUG));
        action.createParam("authors").setDescription("Comma-separated list of SCM accounts").setExampleValue((Object)"torvalds@linux-foundation.org");
        action.createParam("assignees").setDescription("Comma-separated list of assignee logins. The value '__me__' can be used as a placeholder for user who performs the request").setExampleValue((Object)"admin,usera,__me__");
        action.createParam("assigned").setDescription("To retrieve assigned or unassigned issues").setBooleanPossibleValues();
        action.createParam("languages").setDescription("Comma-separated list of languages. Available since 4.4").setExampleValue((Object)"java,js");
        action.createParam("createdAt").setDescription("Datetime to retrieve issues created during a specific analysis").setExampleValue((Object)"2017-10-19T13:00:00+0200");
        action.createParam("createdAfter").setDescription("To retrieve issues created after the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided. <br>If this parameter is set, createdSince must not be set").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("createdBefore").setDescription("To retrieve issues created before the given date (inclusive). <br>Either a date (server timezone) or datetime can be provided.").setExampleValue((Object)"2017-10-19 or 2017-10-19T13:00:00+0200");
        action.createParam("createdInLast").setDescription("To retrieve issues created during a time span before the current time (exclusive). Accepted units are 'y' for year, 'm' for month, 'w' for week and 'd' for day. If this parameter is set, createdAfter must not be set").setExampleValue((Object)"1m2w (1 month 2 weeks)");
        action.createParam("sinceLeakPeriod").setDescription("To retrieve issues created since the leak period.<br>If this parameter is set to a truthy value, createdAfter must not be set and one component id or key must be provided.").setBooleanPossibleValues().setDefaultValue((Object)"false");
    }

    private static void addComponentRelatedParams(WebService.NewAction action) {
        action.createParam("onComponentOnly").setDescription("Return only issues at a component's level, not on its descendants (modules, directories, files, etc). This parameter is only considered when componentKeys or componentUuids is set. Using the deprecated componentRoots or componentRootUuids parameters will set this parameter to false. Using the deprecated components parameter will set this parameter to true.").setBooleanPossibleValues().setDefaultValue((Object)"false");
        action.createParam("componentKeys").setDescription("Comma-separated list of component keys. Retrieve issues associated to a specific list of components (and all its descendants). A component can be a portfolio, project, module, directory or file.").setExampleValue((Object)"my_project");
        action.createParam("components").setDeprecatedSince("5.1").setDescription("If used, will have the same meaning as componentKeys AND onComponentOnly=true.");
        action.createParam("componentUuids").setDescription("To retrieve issues associated to a specific list of components their sub-components (comma-separated list of component IDs). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. A component can be a project, module, directory or file.").setDeprecatedSince("6.5").setExampleValue((Object)"584a89f2-8037-4f7b-b82c-8b45d2d63fb2");
        action.createParam("componentRoots").setDeprecatedSince("5.1").setDescription("If used, will have the same meaning as componentKeys AND onComponentOnly=false.");
        action.createParam("componentRootUuids").setDeprecatedSince("5.1").setDescription("If used, will have the same meaning as componentUuids AND onComponentOnly=false.");
        action.createParam("projects").setDescription("To retrieve issues associated to a specific list of projects (comma-separated list of project keys). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. If this parameter is set, projectUuids must not be set.").setDeprecatedKey("projectKeys", "6.5").setInternal(true).setExampleValue((Object)"my_project");
        action.createParam("projectUuids").setDescription("To retrieve issues associated to a specific list of projects (comma-separated list of project IDs). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. Portfolios are not supported. If this parameter is set, '%s' must not be set.", new Object[]{"projects"}).setInternal(true).setExampleValue((Object)"7d8749e8-3070-4903-9188-bdd82933bb92");
        action.createParam("moduleUuids").setDescription("To retrieve issues associated to a specific list of modules (comma-separated list of module IDs). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. ").setInternal(true).setExampleValue((Object)"7d8749e8-3070-4903-9188-bdd82933bb92");
        action.createParam("directories").setDescription("To retrieve issues associated to a specific list of directories (comma-separated list of directory paths). This parameter is only meaningful when a module is selected. This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. ").setInternal(true).setSince("5.1").setExampleValue((Object)"src/main/java/org/sonar/server/");
        action.createParam("fileUuids").setDescription("To retrieve issues associated to a specific list of files (comma-separated list of file IDs). This parameter is mostly used by the Issues page, please prefer usage of the componentKeys parameter. ").setInternal(true).setExampleValue((Object)"bdd82933-3070-4903-9188-7d8749e8bb92");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        action.createParam("pullRequest").setDescription("Pull request id").setExampleValue((Object)"5461").setInternal(true).setSince("7.1");
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.4");
    }

    public final void handle(Request request, Response response) {
        SearchRequest searchRequest = SearchAction.toSearchWsRequest(request).setAssigneesUuid(this.getLogins(request));
        Issues.SearchWsResponse searchWsResponse = this.doHandle(searchRequest, request);
        WsUtils.writeProtobuf((Message)searchWsResponse, request, response);
    }

    private List<String> getLogins(Request request) {
        List assigneeLogins = request.paramAsStrings("assignees");
        ArrayList<String> onlyLogins = new ArrayList<String>();
        for (String login : Optional.ofNullable(assigneeLogins).orElse(Collections.emptyList())) {
            if (LOGIN_MYSELF.equals(login)) {
                if (this.userSession.getLogin() == null) {
                    onlyLogins.add("<UNKNOWN>");
                    continue;
                }
                onlyLogins.add(this.userSession.getLogin());
                continue;
            }
            onlyLogins.add(login);
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List userDtos = this.dbClient.userDao().selectByLogins(dbSession, onlyLogins);
            ImmutableList assigneeUuid = userDtos.stream().map(UserDto::getUuid).collect(Collectors.toList());
            if (assigneeLogins != null && ((List)MoreObjects.firstNonNull(assigneeUuid, Collections.emptyList())).isEmpty()) {
                assigneeUuid = ImmutableList.of((Object)"non-existent-uuid");
            }
            ImmutableList immutableList = assigneeUuid;
            return immutableList;
        }
    }

    private Issues.SearchWsResponse doHandle(SearchRequest request, Request wsRequest) {
        SearchOptions options = SearchAction.createSearchOptionsFromRequest(request);
        EnumSet<SearchAdditionalField> additionalFields = SearchAdditionalField.getFromRequest(request);
        IssueQuery query = this.issueQueryFactory.create(request);
        SearchResponse result = this.issueIndex.search(query, options);
        List issueKeys = (List)Arrays.stream(result.getHits().getHits()).map(SearchHit::getId).collect(MoreCollectors.toList((int)result.getHits().getHits().length));
        SearchResponseLoader.Collector collector = new SearchResponseLoader.Collector(additionalFields, issueKeys);
        this.collectLoggedInUser(collector);
        SearchAction.collectRequestParams(collector, request);
        Facets facets = null;
        if (!options.getFacets().isEmpty()) {
            facets = new Facets(result, this.system2.getDefaultTimeZone());
            this.completeFacets(facets, request, wsRequest);
            SearchAction.collectFacets(collector, facets);
            Set facetsRequiringProjectOrOrganizationParameter = (Set)facets.getNames().stream().filter(FACETS_REQUIRING_PROJECT_OR_ORGANIZATION::contains).collect(MoreCollectors.toSet());
            Preconditions.checkArgument((facetsRequiringProjectOrOrganizationParameter.isEmpty() || !query.projectUuids().isEmpty() || query.organizationUuid() != null ? 1 : 0) != 0, (String)"Facet(s) '%s' require to also filter by project or organization", (Object[])new Object[]{COMA_JOINER.join((Iterable)facetsRequiringProjectOrOrganizationParameter)});
        }
        SearchResponseData preloadedData = new SearchResponseData(Collections.emptyList());
        preloadedData.setRules((List<RuleDefinitionDto>)ImmutableList.copyOf(query.rules()));
        SearchResponseData data = this.searchResponseLoader.load(preloadedData, collector, facets);
        facets = this.reorderFacets(facets, options.getFacets());
        this.replaceRuleIdsByRuleKeys(facets, (List)MoreObjects.firstNonNull(data.getRules(), Collections.emptyList()));
        SearchAction.replaceAssigneeUuidByUserLogin(facets, data, "assignees");
        SearchAction.replaceAssigneeUuidByUserLogin(facets, data, "assigned_to_me");
        Paging paging = Paging.forPageIndex((int)options.getPage()).withPageSize(options.getLimit()).andTotal((int)result.getHits().getTotalHits());
        return this.searchResponseFormat.formatSearch(additionalFields, data, paging, facets);
    }

    private static void replaceAssigneeUuidByUserLogin(@Nullable Facets facets, SearchResponseData data, String facet) {
        if (facets == null) {
            return;
        }
        LinkedHashMap<String, Long> assigneeFacets = facets.get(facet);
        if (assigneeFacets == null) {
            return;
        }
        LinkedHashMap newAssigneeFacets = new LinkedHashMap();
        assigneeFacets.forEach((userUuid, v) -> {
            UserDto user = data.getUserByUuid((String)userUuid);
            newAssigneeFacets.put(user == null ? "" : user.getLogin(), v);
        });
        assigneeFacets.clear();
        assigneeFacets.putAll(newAssigneeFacets);
    }

    private void replaceRuleIdsByRuleKeys(@Nullable Facets facets, List<RuleDefinitionDto> alreadyLoadedRules) {
        if (facets == null) {
            return;
        }
        LinkedHashMap<String, Long> rulesFacet = facets.get("rules");
        if (rulesFacet == null) {
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            HashSet ruleIdsToLoad = new HashSet();
            rulesFacet.keySet().forEach(s -> {
                try {
                    ruleIdsToLoad.add(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
            ruleIdsToLoad.removeAll(alreadyLoadedRules.stream().map(RuleDefinitionDto::getId).collect(Collectors.toList()));
            List ruleDefinitions = (List)Stream.concat(alreadyLoadedRules.stream(), this.dbClient.ruleDao().selectDefinitionByIds(dbSession, ruleIdsToLoad).stream()).collect(MoreCollectors.toList());
            Map<Integer, RuleKey> ruleKeyById = ruleDefinitions.stream().collect(Collectors.toMap(RuleDefinitionDto::getId, RuleDefinitionDto::getKey));
            Map<String, Integer> idByRuleKeyAsString = ruleDefinitions.stream().collect(Collectors.toMap(s -> s.getKey().toString(), RuleDefinitionDto::getId));
            LinkedHashMap newRulesFacet = new LinkedHashMap();
            rulesFacet.forEach((k, v) -> {
                block4: {
                    try {
                        int ruleId = Integer.parseInt(k);
                        RuleKey ruleKey = (RuleKey)ruleKeyById.get(ruleId);
                        if (ruleKey != null) {
                            newRulesFacet.put(ruleKey.toString(), v);
                        } else {
                            LOGGER.error("Rule with id {} is not available in database", k);
                        }
                    }
                    catch (NumberFormatException e) {
                        String ruleId = String.valueOf(idByRuleKeyAsString.get(k));
                        if (rulesFacet.containsKey(ruleId)) break block4;
                        newRulesFacet.put(k, v);
                    }
                }
            });
            rulesFacet.clear();
            rulesFacet.putAll(newRulesFacet);
        }
    }

    private static SearchOptions createSearchOptionsFromRequest(SearchRequest request) {
        SearchOptions options = new SearchOptions();
        options.setPage(request.getPage(), request.getPageSize());
        options.addFacets(request.getFacets());
        return options;
    }

    private Facets reorderFacets(@Nullable Facets facets, Collection<String> orderedNames) {
        if (facets == null) {
            return null;
        }
        LinkedHashMap<String, LinkedHashMap<String, Long>> orderedFacets = new LinkedHashMap<String, LinkedHashMap<String, Long>>();
        for (String facetName : orderedNames) {
            LinkedHashMap<String, Long> facet = facets.get(facetName);
            if (facet == null) continue;
            orderedFacets.put(facetName, facet);
        }
        return new Facets(orderedFacets, this.system2.getDefaultTimeZone());
    }

    private void completeFacets(Facets facets, SearchRequest request, Request wsRequest) {
        SearchAction.addMandatoryValuesToFacet(facets, "severities", Severity.ALL);
        SearchAction.addMandatoryValuesToFacet(facets, "statuses", Issue.STATUSES);
        SearchAction.addMandatoryValuesToFacet(facets, "resolutions", Iterables.concat(Collections.singletonList(""), (Iterable)Issue.RESOLUTIONS));
        SearchAction.addMandatoryValuesToFacet(facets, "projectUuids", request.getProjectUuids());
        ArrayList assignees = Lists.newArrayList((Object[])new String[]{""});
        List<String> assigneesFromRequest = request.getAssigneeUuids();
        if (assigneesFromRequest != null) {
            assignees.addAll(assigneesFromRequest);
            assignees.remove(LOGIN_MYSELF);
        }
        SearchAction.addMandatoryValuesToFacet(facets, "assignees", assignees);
        SearchAction.addMandatoryValuesToFacet(facets, "assigned_to_me", Collections.singletonList(this.userSession.getUuid()));
        SearchAction.addMandatoryValuesToFacet(facets, "rules", request.getRules());
        SearchAction.addMandatoryValuesToFacet(facets, "languages", request.getLanguages());
        SearchAction.addMandatoryValuesToFacet(facets, "tags", request.getTags());
        SearchAction.addMandatoryValuesToFacet(facets, "types", RuleType.names());
        SearchAction.addMandatoryValuesToFacet(facets, "componentUuids", request.getComponentUuids());
        List<String> requestedFacets = request.getFacets();
        if (requestedFacets == null) {
            return;
        }
        requestedFacets.stream().filter(facetName -> !"assigned_to_me".equals(facetName)).filter(facetName -> !"assignees".equals(facetName)).filter(facetName -> !IGNORED_FACETS.contains(facetName)).forEach(facetName -> {
            LinkedHashMap<String, Long> buckets = facets.get((String)facetName);
            List requestParams = wsRequest.paramAsStrings(facetName);
            if (buckets == null || requestParams == null) {
                return;
            }
            requestParams.stream().filter(param -> !buckets.containsKey(param) && !LOGIN_MYSELF.equals(param)).forEach(param -> buckets.put((String)param, 0L));
        });
    }

    private static void addMandatoryValuesToFacet(Facets facets, String facetName, @Nullable Iterable<String> mandatoryValues) {
        LinkedHashMap<String, Long> buckets = facets.get(facetName);
        if (buckets != null && mandatoryValues != null) {
            for (String mandatoryValue : mandatoryValues) {
                if (buckets.containsKey(mandatoryValue)) continue;
                buckets.put(mandatoryValue, 0L);
            }
        }
    }

    private void collectLoggedInUser(SearchResponseLoader.Collector collector) {
        if (this.userSession.isLoggedIn()) {
            collector.add(SearchAdditionalField.USERS, this.userSession.getUuid());
        }
    }

    private static void collectFacets(SearchResponseLoader.Collector collector, Facets facets) {
        Set<String> facetRules = facets.getBucketKeys("rules");
        if (facetRules != null) {
            collector.addAll(SearchAdditionalField.RULE_IDS_AND_KEYS, facetRules);
        }
        collector.addProjectUuids(facets.getBucketKeys("projectUuids"));
        collector.addComponentUuids(facets.getBucketKeys("componentUuids"));
        collector.addComponentUuids(facets.getBucketKeys("fileUuids"));
        collector.addComponentUuids(facets.getBucketKeys("moduleUuids"));
        collector.addAll(SearchAdditionalField.USERS, facets.getBucketKeys("assignees"));
    }

    private static void collectRequestParams(SearchResponseLoader.Collector collector, SearchRequest request) {
        collector.addProjectUuids(request.getProjectUuids());
        collector.addComponentUuids(request.getFileUuids());
        collector.addComponentUuids(request.getModuleUuids());
        collector.addComponentUuids(request.getComponentRootUuids());
        collector.addAll(SearchAdditionalField.USERS, request.getAssigneeUuids());
    }

    private static SearchRequest toSearchWsRequest(Request request) {
        return new SearchRequest().setAdditionalFields(request.paramAsStrings("additionalFields")).setAsc(request.paramAsBoolean("asc")).setAssigned(request.paramAsBoolean("assigned")).setAuthors(request.paramAsStrings("authors")).setComponentKeys(request.paramAsStrings("componentKeys")).setComponentRootUuids(request.paramAsStrings("componentRootUuids")).setComponentRoots(request.paramAsStrings("componentRoots")).setComponentUuids(request.paramAsStrings("componentUuids")).setComponents(request.paramAsStrings("components")).setCreatedAfter(request.param("createdAfter")).setCreatedAt(request.param("createdAt")).setCreatedBefore(request.param("createdBefore")).setCreatedInLast(request.param("createdInLast")).setDirectories(request.paramAsStrings("directories")).setFacetMode(request.mandatoryParam("facetMode")).setFacets(request.paramAsStrings("facets")).setFileUuids(request.paramAsStrings("fileUuids")).setIssues(request.paramAsStrings("issues")).setLanguages(request.paramAsStrings("languages")).setModuleUuids(request.paramAsStrings("moduleUuids")).setOnComponentOnly(request.paramAsBoolean("onComponentOnly")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest")).setOrganization(request.param("organization")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setProjectKeys(request.paramAsStrings("projects")).setProjectUuids(request.paramAsStrings("projectUuids")).setProjects(request.paramAsStrings("projects")).setResolutions(request.paramAsStrings("resolutions")).setResolved(request.paramAsBoolean("resolved")).setRules(request.paramAsStrings("rules")).setSinceLeakPeriod(request.mandatoryParamAsBoolean("sinceLeakPeriod")).setSort(request.param("s")).setSeverities(request.paramAsStrings("severities")).setStatuses(request.paramAsStrings("statuses")).setTags(request.paramAsStrings("tags")).setTypes(request.paramAsStrings("types"));
    }
}

