/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.IssueUpdater;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.OperationResponseWriter;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class AssignAction
implements IssuesWsAction {
    private static final String DEPRECATED_PARAM_ME = "me";
    private static final String ASSIGN_TO_ME_VALUE = "_me";
    private final System2 system2;
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueFinder issueFinder;
    private final IssueFieldsSetter issueFieldsSetter;
    private final IssueUpdater issueUpdater;
    private final OperationResponseWriter responseWriter;

    public AssignAction(System2 system2, UserSession userSession, DbClient dbClient, IssueFinder issueFinder, IssueFieldsSetter issueFieldsSetter, IssueUpdater issueUpdater, OperationResponseWriter responseWriter) {
        this.system2 = system2;
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueFinder = issueFinder;
        this.issueFieldsSetter = issueFieldsSetter;
        this.issueUpdater = issueUpdater;
        this.responseWriter = responseWriter;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("assign").setDescription("Assign/Unassign an issue. Requires authentication and Browse permission on project").setSince("3.6").setChangelog(new Change[]{new Change("6.5", "the database ids of the components are removed from the response"), new Change("6.5", "the response field components.uuid is deprecated. Use components.key instead.")}).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"assign-example.json")).setPost(true);
        action.createParam("issue").setDescription("Issue key").setRequired(true).setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("assignee").setDescription("Login of the assignee. When not set, it will unassign the issue. Use '%s' to assign to current user", new Object[]{ASSIGN_TO_ME_VALUE}).setExampleValue((Object)"admin");
        action.createParam(DEPRECATED_PARAM_ME).setDescription("(deprecated) Assign the issue to the logged-in user. Replaced by the parameter assignee=_me").setDeprecatedSince("5.2").setBooleanPossibleValues();
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String assignee = this.getAssignee(request);
        String key = request.mandatoryParam("issue");
        SearchResponseData preloadedResponseData = this.assign(key, assignee);
        this.responseWriter.write(key, preloadedResponseData, request, response);
    }

    private SearchResponseData assign(String issueKey, @Nullable String login) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            IssueChangeContext context;
            IssueDto issueDto = this.issueFinder.getByKey(dbSession, issueKey);
            DefaultIssue issue = issueDto.toDefaultIssue();
            UserDto user = this.getUser(dbSession, login);
            if (user != null) {
                this.checkMembership(dbSession, issueDto, user);
            }
            if (this.issueFieldsSetter.assign(issue, user, context = IssueChangeContext.createUser((Date)new Date(this.system2.now()), (String)this.userSession.getUuid()))) {
                SearchResponseData searchResponseData = this.issueUpdater.saveIssueAndPreloadSearchResponseData(dbSession, issue, context, null, false);
                return searchResponseData;
            }
            SearchResponseData searchResponseData = new SearchResponseData(issueDto);
            return searchResponseData;
        }
    }

    @CheckForNull
    private String getAssignee(Request request) {
        String assignee = Strings.emptyToNull((String)request.param("assignee"));
        if (ASSIGN_TO_ME_VALUE.equals(assignee) || BooleanUtils.isTrue((Boolean)request.paramAsBoolean(DEPRECATED_PARAM_ME))) {
            return this.userSession.getLogin();
        }
        return assignee;
    }

    @CheckForNull
    private UserDto getUser(DbSession dbSession, @Nullable String assignee) {
        if (Strings.isNullOrEmpty((String)assignee)) {
            return null;
        }
        return WsUtils.checkFound(this.dbClient.userDao().selectActiveUserByLogin(dbSession, assignee), "Unknown user: %s", assignee);
    }

    private void checkMembership(DbSession dbSession, IssueDto issueDto, UserDto user) {
        String projectUuid = Objects.requireNonNull(issueDto.getProjectUuid());
        ComponentDto project = (ComponentDto)Optional.ofNullable(this.dbClient.componentDao().selectByUuid(dbSession, projectUuid).orNull()).orElseThrow(() -> new IllegalStateException(String.format("Unknown project %s", projectUuid)));
        OrganizationDto organizationDto = (OrganizationDto)this.dbClient.organizationDao().selectByUuid(dbSession, project.getOrganizationUuid()).orElseThrow(() -> new IllegalStateException(String.format("Unknown organizationMember %s", project.getOrganizationUuid())));
        Preconditions.checkArgument((boolean)this.dbClient.organizationMemberDao().select(dbSession, organizationDto.getUuid(), user.getId().intValue()).isPresent(), (String)"User '%s' is not member of organization '%s'", (Object[])new Object[]{user.getLogin(), organizationDto.getKey()});
    }
}

