/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.workflow;

import javax.annotation.Nullable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.issue.Issue;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.workflow.Function;

@ServerSide
@ComputeEngineSide
public class FunctionExecutor {
    private final IssueFieldsSetter updater;

    public FunctionExecutor(IssueFieldsSetter updater) {
        this.updater = updater;
    }

    public void execute(Function[] functions, DefaultIssue issue, IssueChangeContext changeContext) {
        if (functions.length > 0) {
            FunctionContext functionContext = new FunctionContext(this.updater, issue, changeContext);
            for (Function function : functions) {
                function.execute(functionContext);
            }
        }
    }

    static class FunctionContext
    implements Function.Context {
        private final IssueFieldsSetter updater;
        private final DefaultIssue issue;
        private final IssueChangeContext changeContext;

        FunctionContext(IssueFieldsSetter updater, DefaultIssue issue, IssueChangeContext changeContext) {
            this.updater = updater;
            this.issue = issue;
            this.changeContext = changeContext;
        }

        @Override
        public Issue issue() {
            return this.issue;
        }

        @Override
        public Function.Context setAssignee(@Nullable UserDto user) {
            this.updater.assign(this.issue, user, this.changeContext);
            return this;
        }

        @Override
        public Function.Context setResolution(@Nullable String s) {
            this.updater.setResolution(this.issue, s, this.changeContext);
            return this;
        }

        @Override
        public Function.Context setCloseDate(boolean b) {
            this.updater.setCloseDate(this.issue, b ? this.changeContext.date() : null, this.changeContext);
            return this;
        }

        @Override
        public Function.Context setLine(@Nullable Integer line) {
            this.updater.setLine(this.issue, line);
            return this;
        }
    }
}

