/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbClient;
import org.sonar.server.issue.index.IssueDoc;
import org.sonar.server.issue.index.IssueIterator;
import org.sonar.server.issue.index.IssueIteratorForSingleChunk;

public class IssueIteratorForMultipleChunks
implements IssueIterator {
    private final DbClient dbClient;
    private final Iterator<List<String>> iteratorOverChunks;
    private IssueIteratorForSingleChunk currentChunk;

    public IssueIteratorForMultipleChunks(DbClient dbClient, Collection<String> issueKeys) {
        this.dbClient = dbClient;
        this.iteratorOverChunks = DatabaseUtils.toUniqueAndSortedPartitions(issueKeys).iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currentChunk != null && this.currentChunk.hasNext()) {
            return true;
        }
        return this.iteratorOverChunks.hasNext();
    }

    @Override
    public IssueDoc next() {
        if (this.currentChunk == null || !this.currentChunk.hasNext()) {
            this.currentChunk = this.nextChunk();
        }
        return this.currentChunk.next();
    }

    private IssueIteratorForSingleChunk nextChunk() {
        List<String> nextInput = this.iteratorOverChunks.next();
        return new IssueIteratorForSingleChunk(this.dbClient, null, nextInput);
    }

    @Override
    public void close() {
        Optional.ofNullable(this.currentChunk).ifPresent(IssueIterator::close);
    }
}

