/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.TermsLookup;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.elasticsearch.search.aggregations.metrics.min.Min;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.valuecount.InternalValueCount;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.EsUtils;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.Sorting;
import org.sonar.server.es.StickyFacetBuilder;
import org.sonar.server.issue.IssueQuery;
import org.sonar.server.issue.index.BranchStatistics;
import org.sonar.server.issue.index.IssueIndexDefinition;
import org.sonar.server.issue.index.ProjectStatistics;
import org.sonar.server.permission.index.AuthorizationTypeSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.view.index.ViewIndexDefinition;

public class IssueIndex {
    public static final List<String> SUPPORTED_FACETS = ImmutableList.of((Object)"severities", (Object)"statuses", (Object)"resolutions", (Object)"actionPlans", (Object)"projectUuids", (Object)"rules", (Object)"assignees", (Object)"assigned_to_me", (Object)"reporters", (Object)"authors", (Object)"moduleUuids", (Object)"fileUuids", (Object[])new String[]{"directories", "languages", "tags", "types", "createdAt"});
    public static final String AGGREGATION_NAME_FOR_TAGS = "tags__issues";
    private static final String SUBSTRING_MATCH_REGEXP = ".*%s.*";
    private static final String FACET_SUFFIX_MISSING = "_missing";
    private static final String IS_ASSIGNED_FILTER = "__isAssigned";
    private static final SumAggregationBuilder EFFORT_AGGREGATION = (SumAggregationBuilder)AggregationBuilders.sum((String)"effort").field("effort");
    private static final Terms.Order EFFORT_AGGREGATION_ORDER = Terms.Order.aggregation((String)"effort", (boolean)false);
    private static final int DEFAULT_FACET_SIZE = 15;
    private static final Duration TWENTY_DAYS = Duration.standardDays((long)20L);
    private static final Duration TWENTY_WEEKS = Duration.standardDays((long)140L);
    private static final Duration TWENTY_MONTHS = Duration.standardDays((long)600L);
    private final Sorting sorting;
    private final EsClient client;
    private final System2 system;
    private final UserSession userSession;
    private final AuthorizationTypeSupport authorizationTypeSupport;

    public IssueIndex(EsClient client, System2 system, UserSession userSession, AuthorizationTypeSupport authorizationTypeSupport) {
        this.client = client;
        this.system = system;
        this.userSession = userSession;
        this.authorizationTypeSupport = authorizationTypeSupport;
        this.sorting = new Sorting();
        this.sorting.add("STATUS", "status");
        this.sorting.add("SEVERITY", "severityValue");
        this.sorting.add("CREATION_DATE", "issueCreatedAt");
        this.sorting.add("UPDATE_DATE", "issueUpdatedAt");
        this.sorting.add("CLOSE_DATE", "issueClosedAt");
        this.sorting.add("FILE_LINE", "project");
        this.sorting.add("FILE_LINE", "filePath");
        this.sorting.add("FILE_LINE", "line");
        this.sorting.add("FILE_LINE", "severityValue").reverse();
        this.sorting.add("FILE_LINE", "key");
        this.sorting.addDefault("issueCreatedAt").reverse();
        this.sorting.addDefault("project");
        this.sorting.addDefault("filePath");
        this.sorting.addDefault("line");
        this.sorting.addDefault("key");
    }

    private static void configureRouting(IssueQuery query, SearchOptions options, SearchRequestBuilder requestBuilder) {
        Collection<String> uuids = query.projectUuids();
        if (!uuids.isEmpty() && options.getFacets().isEmpty()) {
            requestBuilder.setRouting(uuids.toArray(new String[uuids.size()]));
        }
    }

    private static void configurePagination(SearchOptions options, SearchRequestBuilder esSearch) {
        esSearch.setFrom(options.getOffset()).setSize(options.getLimit());
    }

    private static void addComponentRelatedFilters(IssueQuery query, Map<String, QueryBuilder> filters) {
        QueryBuilder viewFilter = IssueIndex.createViewFilter(query.viewUuids());
        QueryBuilder componentFilter = IssueIndex.createTermsFilter("component", query.componentUuids());
        QueryBuilder projectFilter = IssueIndex.createTermsFilter("project", query.projectUuids());
        QueryBuilder moduleRootFilter = IssueIndex.createTermsFilter("modulePath", query.moduleRootUuids());
        QueryBuilder moduleFilter = IssueIndex.createTermsFilter("module", query.moduleUuids());
        QueryBuilder directoryFilter = IssueIndex.createTermsFilter("dirPath", query.directories());
        QueryBuilder fileFilter = IssueIndex.createTermsFilter("component", query.fileUuids());
        QueryBuilder branchFilter = IssueIndex.createTermFilter("branch", query.branchUuid());
        filters.put("__is_main_branch", IssueIndex.createTermFilter("isMainBranch", Boolean.toString(query.isMainBranch())));
        if (BooleanUtils.isTrue((Boolean)query.onComponentOnly())) {
            filters.put("component", componentFilter);
        } else {
            filters.put("__view", viewFilter);
            filters.put("project", projectFilter);
            filters.put("branch", branchFilter);
            filters.put("__module", moduleRootFilter);
            filters.put("module", moduleFilter);
            filters.put("dirPath", directoryFilter);
            if (fileFilter != null) {
                filters.put("component", fileFilter);
            } else {
                filters.put("component", componentFilter);
            }
        }
    }

    @CheckForNull
    private static QueryBuilder createViewFilter(Collection<String> viewUuids) {
        if (viewUuids.isEmpty()) {
            return null;
        }
        BoolQueryBuilder viewsFilter = QueryBuilders.boolQuery();
        for (String viewUuid : viewUuids) {
            viewsFilter.should((QueryBuilder)QueryBuilders.termsLookupQuery((String)"project", (TermsLookup)new TermsLookup(ViewIndexDefinition.INDEX_TYPE_VIEW.getIndex(), ViewIndexDefinition.INDEX_TYPE_VIEW.getType(), viewUuid, "projects")));
        }
        return viewsFilter;
    }

    private static StickyFacetBuilder newStickyFacetBuilder(IssueQuery query, Map<String, QueryBuilder> filters, QueryBuilder esQuery) {
        if (IssueIndex.hasQueryEffortFacet(query)) {
            return new StickyFacetBuilder(esQuery, filters, (AbstractAggregationBuilder)EFFORT_AGGREGATION, EFFORT_AGGREGATION_ORDER);
        }
        return new StickyFacetBuilder(esQuery, filters);
    }

    private static void addSimpleStickyFacetIfNeeded(SearchOptions options, StickyFacetBuilder stickyFacetBuilder, SearchRequestBuilder esSearch, String facetName, String fieldName, Object ... selectedValues) {
        if (options.getFacets().contains(facetName)) {
            esSearch.addAggregation(stickyFacetBuilder.buildStickyFacet(fieldName, facetName, 15, selectedValues));
        }
    }

    private static AggregationBuilder addEffortAggregationIfNeeded(IssueQuery query, AggregationBuilder aggregation) {
        if (IssueIndex.hasQueryEffortFacet(query)) {
            aggregation.subAggregation((AggregationBuilder)EFFORT_AGGREGATION);
        }
        return aggregation;
    }

    private static boolean hasQueryEffortFacet(IssueQuery query) {
        return "effort".equals(query.facetMode()) || "debt".equals(query.facetMode());
    }

    private static AggregationBuilder createAssigneesFacet(IssueQuery query, Map<String, QueryBuilder> filters, QueryBuilder queryBuilder) {
        String fieldName = "assignee";
        String facetName = "assignees";
        HashMap assigneeFilters = Maps.newHashMap(filters);
        assigneeFilters.remove(IS_ASSIGNED_FILTER);
        assigneeFilters.remove(fieldName);
        StickyFacetBuilder assigneeFacetBuilder = IssueIndex.newStickyFacetBuilder(query, assigneeFilters, queryBuilder);
        BoolQueryBuilder facetFilter = assigneeFacetBuilder.getStickyFacetFilter(fieldName);
        FilterAggregationBuilder facetTopAggregation = assigneeFacetBuilder.buildTopFacetAggregation(fieldName, facetName, facetFilter, 15);
        Collection<String> assigneesEscaped = IssueIndex.escapeValuesForFacetInclusion(query.assignees());
        if (!assigneesEscaped.isEmpty()) {
            facetTopAggregation = assigneeFacetBuilder.addSelectedItemsToFacet(fieldName, facetName, facetTopAggregation, t -> t, assigneesEscaped.toArray());
        }
        facetTopAggregation.subAggregation(IssueIndex.addEffortAggregationIfNeeded(query, (AggregationBuilder)AggregationBuilders.missing((String)(facetName + FACET_SUFFIX_MISSING)).field(fieldName)));
        return AggregationBuilders.global((String)facetName).subAggregation((AggregationBuilder)facetTopAggregation);
    }

    private static Collection<String> escapeValuesForFacetInclusion(@Nullable Collection<String> values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return (Collection)values.stream().map(Pattern::quote).collect(MoreCollectors.toArrayList((int)values.size()));
    }

    private static AggregationBuilder createResolutionFacet(IssueQuery query, Map<String, QueryBuilder> filters, QueryBuilder esQuery) {
        String fieldName = "resolution";
        String facetName = "resolutions";
        HashMap resolutionFilters = Maps.newHashMap(filters);
        resolutionFilters.remove("__isResolved");
        resolutionFilters.remove(fieldName);
        StickyFacetBuilder assigneeFacetBuilder = IssueIndex.newStickyFacetBuilder(query, resolutionFilters, esQuery);
        BoolQueryBuilder facetFilter = assigneeFacetBuilder.getStickyFacetFilter(fieldName);
        FilterAggregationBuilder facetTopAggregation = assigneeFacetBuilder.buildTopFacetAggregation(fieldName, facetName, facetFilter, 15);
        facetTopAggregation = assigneeFacetBuilder.addSelectedItemsToFacet(fieldName, facetName, facetTopAggregation, t -> t, new Object[0]);
        facetTopAggregation.subAggregation(IssueIndex.addEffortAggregationIfNeeded(query, (AggregationBuilder)AggregationBuilders.missing((String)(facetName + FACET_SUFFIX_MISSING)).field(fieldName)));
        return AggregationBuilders.global((String)facetName).subAggregation((AggregationBuilder)facetTopAggregation);
    }

    @CheckForNull
    private static QueryBuilder createTermsFilter(String field, Collection<?> values) {
        return values.isEmpty() ? null : QueryBuilders.termsQuery((String)field, values);
    }

    @CheckForNull
    private static QueryBuilder createTermFilter(String field, @Nullable String value) {
        return value == null ? null : QueryBuilders.termQuery((String)field, (String)value);
    }

    public SearchResponse search(IssueQuery query, SearchOptions options) {
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(IssueIndexDefinition.INDEX_TYPE_ISSUE);
        this.configureSorting(query, requestBuilder);
        IssueIndex.configurePagination(options, requestBuilder);
        IssueIndex.configureRouting(query, options, requestBuilder);
        MatchAllQueryBuilder esQuery = QueryBuilders.matchAllQuery();
        BoolQueryBuilder esFilter = QueryBuilders.boolQuery();
        Map<String, QueryBuilder> filters = this.createFilters(query);
        for (QueryBuilder filter : filters.values()) {
            if (filter == null) continue;
            esFilter.must(filter);
        }
        if (esFilter.hasClauses()) {
            requestBuilder.setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)esQuery).filter((QueryBuilder)esFilter));
        } else {
            requestBuilder.setQuery((QueryBuilder)esQuery);
        }
        this.configureStickyFacets(query, options, filters, (QueryBuilder)esQuery, requestBuilder);
        requestBuilder.setFetchSource(false);
        return (SearchResponse)requestBuilder.get();
    }

    private void configureSorting(IssueQuery query, SearchRequestBuilder esRequest) {
        this.createSortBuilders(query).forEach(arg_0 -> ((SearchRequestBuilder)esRequest).addSort(arg_0));
    }

    private List<FieldSortBuilder> createSortBuilders(IssueQuery query) {
        String sortField = query.sort();
        if (sortField != null) {
            boolean asc = BooleanUtils.isTrue((Boolean)query.asc());
            return this.sorting.fill(sortField, asc);
        }
        return this.sorting.fillDefault();
    }

    private Map<String, QueryBuilder> createFilters(IssueQuery query) {
        HashMap<String, QueryBuilder> filters = new HashMap<String, QueryBuilder>();
        filters.put("__authorization", this.createAuthorizationFilter(query.checkAuthorization()));
        if (BooleanUtils.isTrue((Boolean)query.assigned())) {
            filters.put(IS_ASSIGNED_FILTER, (QueryBuilder)QueryBuilders.existsQuery((String)"assignee"));
        } else if (BooleanUtils.isFalse((Boolean)query.assigned())) {
            filters.put(IS_ASSIGNED_FILTER, (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"assignee")));
        }
        String isResolved = "__isResolved";
        if (BooleanUtils.isTrue((Boolean)query.resolved())) {
            filters.put(isResolved, (QueryBuilder)QueryBuilders.existsQuery((String)"resolution"));
        } else if (BooleanUtils.isFalse((Boolean)query.resolved())) {
            filters.put(isResolved, (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"resolution")));
        }
        filters.put("key", IssueIndex.createTermsFilter("key", query.issueKeys()));
        filters.put("assignee", IssueIndex.createTermsFilter("assignee", query.assignees()));
        IssueIndex.addComponentRelatedFilters(query, filters);
        filters.put("language", IssueIndex.createTermsFilter("language", query.languages()));
        filters.put("tags", IssueIndex.createTermsFilter("tags", query.tags()));
        filters.put("type", IssueIndex.createTermsFilter("type", query.types()));
        filters.put("resolution", IssueIndex.createTermsFilter("resolution", query.resolutions()));
        filters.put("authorLogin", IssueIndex.createTermsFilter("authorLogin", query.authors()));
        filters.put("ruleId", IssueIndex.createTermsFilter("ruleId", query.rules().stream().map(RuleDefinitionDto::getId).collect(Collectors.toList())));
        filters.put("severity", IssueIndex.createTermsFilter("severity", query.severities()));
        filters.put("status", IssueIndex.createTermsFilter("status", query.statuses()));
        filters.put("organization", IssueIndex.createTermFilter("organization", query.organizationUuid()));
        this.addDatesFilter(filters, query);
        IssueIndex.addCreatedAfterByProjectsFilter(filters, query);
        return filters;
    }

    private QueryBuilder createAuthorizationFilter(boolean checkAuthorization) {
        if (checkAuthorization) {
            return this.authorizationTypeSupport.createQueryFilter();
        }
        return QueryBuilders.matchAllQuery();
    }

    private void addDatesFilter(Map<String, QueryBuilder> filters, IssueQuery query) {
        Date createdAt;
        IssueQuery.PeriodStart createdAfter = query.createdAfter();
        Date createdBefore = query.createdBefore();
        this.validateCreationDateBounds(createdBefore, createdAfter != null ? createdAfter.date() : null);
        if (createdAfter != null) {
            filters.put("__createdAfter", (QueryBuilder)QueryBuilders.rangeQuery((String)"issueCreatedAt").from((Object)BaseDoc.dateToEpochSeconds(createdAfter.date()), createdAfter.inclusive()));
        }
        if (createdBefore != null) {
            filters.put("__createdBefore", (QueryBuilder)QueryBuilders.rangeQuery((String)"issueCreatedAt").lt((Object)BaseDoc.dateToEpochSeconds(createdBefore)));
        }
        if ((createdAt = query.createdAt()) != null) {
            filters.put("__createdAt", (QueryBuilder)QueryBuilders.termQuery((String)"issueCreatedAt", (long)BaseDoc.dateToEpochSeconds(createdAt)));
        }
    }

    private static void addCreatedAfterByProjectsFilter(Map<String, QueryBuilder> filters, IssueQuery query) {
        Map<String, IssueQuery.PeriodStart> createdAfterByProjectUuids = query.createdAfterByProjectUuids();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        createdAfterByProjectUuids.forEach((projectUuid, createdAfterDate) -> boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"project", (String)projectUuid)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"issueCreatedAt").from((Object)BaseDoc.dateToEpochSeconds(createdAfterDate.date()), createdAfterDate.inclusive()))));
        filters.put("createdAfterByProjectUuids", (QueryBuilder)boolQueryBuilder);
    }

    private void validateCreationDateBounds(@Nullable Date createdBefore, @Nullable Date createdAfter) {
        Preconditions.checkArgument((createdAfter == null || createdAfter.before(new Date(this.system.now())) ? 1 : 0) != 0, (Object)"Start bound cannot be in the future");
        Preconditions.checkArgument((createdAfter == null || createdBefore == null || createdAfter.before(createdBefore) ? 1 : 0) != 0, (Object)"Start bound cannot be larger or equal to end bound");
    }

    private void configureStickyFacets(IssueQuery query, SearchOptions options, Map<String, QueryBuilder> filters, QueryBuilder esQuery, SearchRequestBuilder esSearch) {
        if (!options.getFacets().isEmpty()) {
            StickyFacetBuilder stickyFacetBuilder = IssueIndex.newStickyFacetBuilder(query, filters, esQuery);
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "severities", "severity", new Object[0]);
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "statuses", "status", new Object[0]);
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "projectUuids", "project", query.projectUuids().toArray());
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "moduleUuids", "module", query.moduleUuids().toArray());
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "directories", "dirPath", query.directories().toArray());
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "fileUuids", "component", query.fileUuids().toArray());
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "languages", "language", query.languages().toArray());
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "rules", "ruleId", query.rules().stream().map(RuleDefinitionDto::getId).toArray());
            IssueIndex.addSimpleStickyFacetIfNeeded(options, stickyFacetBuilder, esSearch, "authors", "authorLogin", query.authors().toArray());
            if (options.getFacets().contains("tags")) {
                esSearch.addAggregation(stickyFacetBuilder.buildStickyFacet("tags", "tags", query.tags().toArray()));
            }
            if (options.getFacets().contains("types")) {
                esSearch.addAggregation(stickyFacetBuilder.buildStickyFacet("type", "types", query.types().toArray()));
            }
            if (options.getFacets().contains("resolutions")) {
                esSearch.addAggregation(IssueIndex.createResolutionFacet(query, filters, esQuery));
            }
            if (options.getFacets().contains("assignees")) {
                esSearch.addAggregation(IssueIndex.createAssigneesFacet(query, filters, esQuery));
            }
            this.addAssignedToMeFacetIfNeeded(esSearch, options, query, filters, esQuery);
            if (options.getFacets().contains("createdAt")) {
                this.getCreatedAtFacet(query, filters, esQuery).ifPresent(arg_0 -> ((SearchRequestBuilder)esSearch).addAggregation(arg_0));
            }
        }
        if (IssueIndex.hasQueryEffortFacet(query)) {
            esSearch.addAggregation((AggregationBuilder)EFFORT_AGGREGATION);
        }
    }

    private Optional<AggregationBuilder> getCreatedAtFacet(IssueQuery query, Map<String, QueryBuilder> filters, QueryBuilder esQuery) {
        boolean startInclusive;
        long startTime;
        IssueQuery.PeriodStart createdAfter = query.createdAfter();
        if (createdAfter == null) {
            Optional<Long> minDate = this.getMinCreatedAt(filters, esQuery);
            if (!minDate.isPresent()) {
                return Optional.empty();
            }
            startTime = minDate.get();
            startInclusive = true;
        } else {
            startTime = createdAfter.date().getTime();
            startInclusive = createdAfter.inclusive();
        }
        Date createdBefore = query.createdBefore();
        long endTime = createdBefore == null ? this.system.now() : createdBefore.getTime();
        Duration timeSpan = new Duration(startTime, endTime);
        DateHistogramInterval bucketSize = DateHistogramInterval.YEAR;
        if (timeSpan.isShorterThan((ReadableDuration)TWENTY_DAYS)) {
            bucketSize = DateHistogramInterval.DAY;
        } else if (timeSpan.isShorterThan((ReadableDuration)TWENTY_WEEKS)) {
            bucketSize = DateHistogramInterval.WEEK;
        } else if (timeSpan.isShorterThan((ReadableDuration)TWENTY_MONTHS)) {
            bucketSize = DateHistogramInterval.MONTH;
        }
        DateHistogramAggregationBuilder dateHistogram = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"createdAt").field("issueCreatedAt")).dateHistogramInterval(bucketSize).minDocCount(0L).format("yyyy-MM-dd'T'HH:mm:ssZ")).timeZone(DateTimeZone.forOffsetMillis((int)this.system.getDefaultTimeZone().getRawOffset()))).extendedBounds(new ExtendedBounds(Long.valueOf(startInclusive ? startTime : startTime + 1L), Long.valueOf(endTime - 1L)));
        IssueIndex.addEffortAggregationIfNeeded(query, (AggregationBuilder)dateHistogram);
        return Optional.of(dateHistogram);
    }

    private Optional<Long> getMinCreatedAt(Map<String, QueryBuilder> filters, QueryBuilder esQuery) {
        String facetNameAndField = "issueCreatedAt";
        SearchRequestBuilder esRequest = this.client.prepareSearch(IssueIndexDefinition.INDEX_TYPE_ISSUE).setSize(0);
        BoolQueryBuilder esFilter = QueryBuilders.boolQuery();
        filters.values().stream().filter(Objects::nonNull).forEach(arg_0 -> ((BoolQueryBuilder)esFilter).must(arg_0));
        if (esFilter.hasClauses()) {
            esRequest.setQuery((QueryBuilder)QueryBuilders.boolQuery().must(esQuery).filter((QueryBuilder)esFilter));
        } else {
            esRequest.setQuery(esQuery);
        }
        esRequest.addAggregation((AggregationBuilder)AggregationBuilders.min((String)facetNameAndField).field(facetNameAndField));
        Min minValue = (Min)((SearchResponse)esRequest.get()).getAggregations().get(facetNameAndField);
        Double actualValue = minValue.getValue();
        if (actualValue.isInfinite()) {
            return Optional.empty();
        }
        return Optional.of(actualValue.longValue());
    }

    private void addAssignedToMeFacetIfNeeded(SearchRequestBuilder builder, SearchOptions options, IssueQuery query, Map<String, QueryBuilder> filters, QueryBuilder queryBuilder) {
        String uuid = this.userSession.getUuid();
        if (!options.getFacets().contains("assigned_to_me") || StringUtils.isEmpty((String)uuid)) {
            return;
        }
        String fieldName = "assignee";
        String facetName = "assigned_to_me";
        StickyFacetBuilder assignedToMeFacetBuilder = IssueIndex.newStickyFacetBuilder(query, filters, queryBuilder);
        BoolQueryBuilder facetFilter = assignedToMeFacetBuilder.getStickyFacetFilter(IS_ASSIGNED_FILTER, fieldName);
        FilterAggregationBuilder facetTopAggregation = (FilterAggregationBuilder)AggregationBuilders.filter((String)(facetName + "__filter"), (QueryBuilder)facetFilter).subAggregation(IssueIndex.addEffortAggregationIfNeeded(query, (AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)(facetName + "__terms")).field(fieldName)).includeExclude(new IncludeExclude(EsUtils.escapeSpecialRegexChars(uuid), null))));
        builder.addAggregation((AggregationBuilder)AggregationBuilders.global((String)facetName).subAggregation((AggregationBuilder)facetTopAggregation));
    }

    public List<String> listTags(@Nullable OrganizationDto organization, @Nullable String textQuery, int size) {
        int maxPageSize = 500;
        Preconditions.checkArgument((size <= maxPageSize ? 1 : 0) != 0, (Object)("Page size must be lower than or equals to " + maxPageSize));
        if (size <= 0) {
            return Collections.emptyList();
        }
        BoolQueryBuilder esQuery = QueryBuilders.boolQuery().filter(this.createAuthorizationFilter(true));
        if (organization != null) {
            esQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"organization", (String)organization.getUuid()));
        }
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(IssueIndexDefinition.INDEX_TYPE_ISSUE).setQuery((QueryBuilder)esQuery).setSize(0);
        TermsAggregationBuilder termsAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGGREGATION_NAME_FOR_TAGS).field("tags")).size(size).order(Terms.Order.term((boolean)true)).minDocCount(1L);
        if (textQuery != null) {
            String escapedTextQuery = EsUtils.escapeSpecialRegexChars(textQuery);
            termsAggregation.includeExclude(new IncludeExclude(String.format(SUBSTRING_MATCH_REGEXP, escapedTextQuery), null));
        }
        requestBuilder.addAggregation((AggregationBuilder)termsAggregation);
        SearchResponse searchResponse = (SearchResponse)requestBuilder.get();
        Terms issuesResult = (Terms)searchResponse.getAggregations().get(AGGREGATION_NAME_FOR_TAGS);
        return EsUtils.termsKeys(issuesResult);
    }

    public Map<String, Long> countTags(IssueQuery query, int maxNumberOfTags) {
        Terms terms = this.listTermsMatching("tags", query, null, Terms.Order.count((boolean)false), maxNumberOfTags);
        return EsUtils.termsToMap(terms);
    }

    public List<String> listAuthors(IssueQuery query, @Nullable String textQuery, int maxNumberOfAuthors) {
        Terms terms = this.listTermsMatching("authorLogin", query, textQuery, Terms.Order.term((boolean)true), maxNumberOfAuthors);
        return EsUtils.termsKeys(terms);
    }

    private Terms listTermsMatching(String fieldName, IssueQuery query, @Nullable String textQuery, Terms.Order termsOrder, int maxNumberOfTags) {
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(IssueIndexDefinition.INDEX_TYPE_ISSUE).setSize(0);
        requestBuilder.setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)this.createBoolFilter(query)));
        TermsAggregationBuilder aggreg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"_ref").field(fieldName)).size(maxNumberOfTags).order(termsOrder).minDocCount(1L);
        if (textQuery != null) {
            aggreg.includeExclude(new IncludeExclude(String.format(SUBSTRING_MATCH_REGEXP, EsUtils.escapeSpecialRegexChars(textQuery)), null));
        }
        SearchResponse searchResponse = (SearchResponse)requestBuilder.addAggregation((AggregationBuilder)aggreg).get();
        return (Terms)searchResponse.getAggregations().get("_ref");
    }

    private BoolQueryBuilder createBoolFilter(IssueQuery query) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (QueryBuilder filter : this.createFilters(query).values()) {
            if (filter == null) continue;
            boolQuery.must(filter);
        }
        return boolQuery;
    }

    public List<ProjectStatistics> searchProjectStatistics(List<String> projectUuids, List<Long> froms, @Nullable String assigneeUuid) {
        Preconditions.checkState((projectUuids.size() == froms.size() ? 1 : 0) != 0, (String)"Expected same size for projectUuids (had size %s) and froms (had size %s)", (Object[])new Object[]{projectUuids.size(), froms.size()});
        if (projectUuids.isEmpty()) {
            return Collections.emptyList();
        }
        SearchRequestBuilder request = this.client.prepareSearch(IssueIndexDefinition.INDEX_TYPE_ISSUE).setQuery((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"resolution")).filter((QueryBuilder)QueryBuilders.termQuery((String)"assignee", (String)assigneeUuid))).setSize(0);
        IntStream.range(0, projectUuids.size()).forEach(i -> {
            String projectUuid = (String)projectUuids.get(i);
            long from = (Long)froms.get(i);
            request.addAggregation((AggregationBuilder)AggregationBuilders.filter((String)projectUuid, (QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"project", (String)projectUuid)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"issueCreatedAt").gte((Object)BaseDoc.epochMillisToEpochSeconds(from)))).subAggregation((AggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"branchUuid").field("branch")).subAggregation((AggregationBuilder)AggregationBuilders.count((String)"count").field("key"))).subAggregation((AggregationBuilder)AggregationBuilders.max((String)"maxFuncCreatedAt").field("issueCreatedAt"))));
        });
        SearchResponse response = (SearchResponse)request.get();
        return (List)response.getAggregations().asList().stream().map(x -> (InternalFilter)x).flatMap(projectBucket -> ((StringTerms)projectBucket.getAggregations().get("branchUuid")).getBuckets().stream().flatMap(branchBucket -> {
            long count = ((InternalValueCount)branchBucket.getAggregations().get("count")).getValue();
            if (count < 1L) {
                return Stream.empty();
            }
            long lastIssueDate = (long)((InternalMax)branchBucket.getAggregations().get("maxFuncCreatedAt")).getValue();
            return Stream.of(new ProjectStatistics(branchBucket.getKeyAsString(), count, lastIssueDate));
        })).collect(MoreCollectors.toList((int)projectUuids.size()));
    }

    public List<BranchStatistics> searchBranchStatistics(String projectUuid, List<String> branchUuids) {
        if (branchUuids.isEmpty()) {
            return Collections.emptyList();
        }
        SearchRequestBuilder request = this.client.prepareSearch(IssueIndexDefinition.INDEX_TYPE_ISSUE).setRouting(projectUuid).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"branch", branchUuids)).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"resolution")).must((QueryBuilder)QueryBuilders.termQuery((String)"isMainBranch", (String)Boolean.toString(false)))).setSize(0).addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"branchUuids").field("branch")).size(branchUuids.size()).subAggregation((AggregationBuilder)AggregationBuilders.terms((String)"types").field("type")));
        SearchResponse response = (SearchResponse)request.get();
        return (List)((StringTerms)response.getAggregations().get("branchUuids")).getBuckets().stream().map(bucket -> new BranchStatistics(bucket.getKeyAsString(), (Map)((StringTerms)bucket.getAggregations().get("types")).getBuckets().stream().collect(MoreCollectors.uniqueIndex(StringTerms.Bucket::getKeyAsString, InternalTerms.Bucket::getDocCount)))).collect(MoreCollectors.toList((int)branchUuids.size()));
    }
}

