/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import java.util.Collection;
import java.util.List;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.issue.IssueChangePostProcessor;
import org.sonar.server.measure.live.LiveMeasureComputer;
import org.sonar.server.qualitygate.changeevent.QGChangeEvent;
import org.sonar.server.qualitygate.changeevent.QGChangeEventListeners;

public class IssueChangePostProcessorImpl
implements IssueChangePostProcessor {
    private final LiveMeasureComputer liveMeasureComputer;
    private final QGChangeEventListeners qualityGateListeners;

    public IssueChangePostProcessorImpl(LiveMeasureComputer liveMeasureComputer, QGChangeEventListeners qualityGateListeners) {
        this.liveMeasureComputer = liveMeasureComputer;
        this.qualityGateListeners = qualityGateListeners;
    }

    @Override
    public void process(DbSession dbSession, List<DefaultIssue> changedIssues, Collection<ComponentDto> components) {
        List<QGChangeEvent> gateChangeEvents = this.liveMeasureComputer.refresh(dbSession, components);
        this.qualityGateListeners.broadcastOnIssueChange(changedIssues, gateChangeEvents);
    }
}

