/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import java.util.Arrays;
import java.util.Set;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.process.cluster.health.NodeDetails;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.server.health.ClusterHealthCheck;
import org.sonar.server.health.ClusterHealthSubCheck;
import org.sonar.server.health.Health;
import org.sonar.server.health.HealthReducer;

public class AppNodeClusterCheck
implements ClusterHealthCheck {
    @Override
    public Health check(Set<NodeHealth> nodeHealths) {
        Set appNodes = (Set)nodeHealths.stream().filter(s -> s.getDetails().getType() == NodeDetails.Type.APPLICATION).collect(MoreCollectors.toSet());
        return Arrays.stream(AppNodeClusterHealthSubChecks.values()).map(s -> s.check(appNodes)).reduce(Health.GREEN, HealthReducer.INSTANCE);
    }

    private static enum AppNodeClusterHealthSubChecks implements ClusterHealthSubCheck
    {
        NO_APPLICATION_NODE{

            @Override
            public Health check(Set<NodeHealth> appNodes) {
                int appNodeCount = appNodes.size();
                if (appNodeCount == 0) {
                    return Health.newHealthCheckBuilder().setStatus(Health.Status.RED).addCause("No application node").build();
                }
                return Health.GREEN;
            }
        }
        ,
        MIN_APPLICATION_NODE_COUNT{

            @Override
            public Health check(Set<NodeHealth> appNodes) {
                int appNodeCount = appNodes.size();
                if (appNodeCount == 1) {
                    return Health.newHealthCheckBuilder().setStatus(Health.Status.YELLOW).addCause("There should be at least two application nodes").build();
                }
                return Health.GREEN;
            }
        }
        ,
        REPORT_RED_OR_YELLOW_NODES{

            @Override
            public Health check(Set<NodeHealth> appNodes) {
                long greenNodesCount;
                int appNodeCount = appNodes.size();
                if (appNodeCount == 0) {
                    return Health.GREEN;
                }
                long redNodesCount = this.withStatus(appNodes, NodeHealth.Status.RED).count();
                long yellowNodesCount = this.withStatus(appNodes, NodeHealth.Status.YELLOW).count();
                if (redNodesCount == 0L && yellowNodesCount == 0L) {
                    return Health.GREEN;
                }
                Health.Builder builder = Health.newHealthCheckBuilder();
                if (redNodesCount == (long)appNodeCount) {
                    return builder.setStatus(Health.Status.RED).addCause("Status of all application nodes is RED").build();
                }
                if (redNodesCount > 0L) {
                    builder.addCause("At least one application node is RED");
                }
                if (yellowNodesCount == (long)appNodeCount) {
                    return builder.setStatus(Health.Status.YELLOW).addCause("Status of all application nodes is YELLOW").build();
                }
                if (yellowNodesCount > 0L) {
                    builder.addCause("At least one application node is YELLOW");
                }
                builder.setStatus((greenNodesCount = this.withStatus(appNodes, NodeHealth.Status.GREEN).count()) > 0L || yellowNodesCount > 0L ? Health.Status.YELLOW : Health.Status.RED);
                return builder.build();
            }
        };

    }
}

