/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.es.EsClient;
import org.sonar.server.platform.db.migration.es.MigrationEsClient;

public class MigrationEsClientImpl
implements MigrationEsClient {
    private final EsClient client;

    public MigrationEsClientImpl(EsClient client) {
        this.client = client;
    }

    public void deleteIndexes(String name, String ... otherNames) {
        GetMappingsResponse mappings = (GetMappingsResponse)this.client.nativeClient().admin().indices().prepareGetMappings(new String[]{"_all"}).get();
        HashSet existingIndices = Sets.newHashSet((Iterator)mappings.mappings().keysIt());
        Stream.concat(Stream.of(name), Arrays.stream(otherNames)).distinct().filter(existingIndices::contains).forEach(this::deleteIndex);
    }

    private void deleteIndex(String index) {
        Loggers.get(this.getClass()).info("Drop Elasticsearch index [{}]", (Object)index);
        this.client.nativeClient().admin().indices().prepareDelete(new String[]{index}).get();
    }
}

