/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.debt;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.server.debt.DebtModelXMLExporter;

@ServerSide
@ComputeEngineSide
public class DebtRulesXMLImporter {
    public List<DebtModelXMLExporter.RuleDebt> importXML(String xml, ValidationMessages validationMessages) {
        return this.importXML(new StringReader(xml), validationMessages);
    }

    public List<DebtModelXMLExporter.RuleDebt> importXML(Reader xml, ValidationMessages validationMessages) {
        ArrayList ruleDebts = Lists.newArrayList();
        try {
            SMInputFactory inputFactory = DebtRulesXMLImporter.initStax();
            SMHierarchicCursor cursor = inputFactory.rootElementCursor(xml);
            cursor.advance();
            SMInputCursor rootCursor = cursor.childElementCursor("chc");
            while (rootCursor.getNext() != null) {
                DebtRulesXMLImporter.process(ruleDebts, validationMessages, rootCursor);
            }
            cursor.getStreamReader().closeCompletely();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
        return ruleDebts;
    }

    private static SMInputFactory initStax() {
        XMLInputFactory xmlFactory = XMLInputFactory2.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        return new SMInputFactory(xmlFactory);
    }

    private static void process(List<DebtModelXMLExporter.RuleDebt> ruleDebts, ValidationMessages validationMessages, SMInputCursor chcCursor) throws XMLStreamException {
        SMInputCursor cursor = chcCursor.childElementCursor();
        while (cursor.getNext() != null) {
            DebtModelXMLExporter.RuleDebt ruleDebt;
            String node = cursor.getLocalName();
            if (StringUtils.equals((String)node, (String)"chc")) {
                DebtRulesXMLImporter.process(ruleDebts, validationMessages, cursor);
                continue;
            }
            if (!StringUtils.equals((String)node, (String)"rule-repo") || (ruleDebt = DebtRulesXMLImporter.processRule(validationMessages, cursor)) == null) continue;
            ruleDebts.add(ruleDebt);
        }
    }

    @CheckForNull
    private static DebtModelXMLExporter.RuleDebt processRule(ValidationMessages validationMessages, SMInputCursor cursor) throws XMLStreamException {
        String ruleRepositoryKey = cursor.collectDescendantText().trim();
        String ruleKey = null;
        Properties properties = new Properties();
        while (cursor.getNext() != null) {
            String node = cursor.getLocalName();
            if (StringUtils.equals((String)node, (String)"prop")) {
                properties.add(DebtRulesXMLImporter.processProperty(validationMessages, cursor));
                continue;
            }
            if (!StringUtils.equals((String)node, (String)"rule-key")) continue;
            ruleKey = cursor.collectDescendantText().trim();
        }
        if (StringUtils.isNotBlank((String)ruleRepositoryKey) && StringUtils.isNotBlank(ruleKey)) {
            return DebtRulesXMLImporter.createRule(RuleKey.of((String)ruleRepositoryKey, ruleKey), properties, validationMessages);
        }
        return null;
    }

    private static Property processProperty(ValidationMessages validationMessages, SMInputCursor cursor) throws XMLStreamException {
        SMInputCursor c = cursor.childElementCursor();
        String key = null;
        int value = 0;
        String textValue = null;
        while (c.getNext() != null) {
            String node = c.getLocalName();
            if (StringUtils.equals((String)node, (String)"key")) {
                key = c.collectDescendantText().trim();
                continue;
            }
            if (StringUtils.equals((String)node, (String)"val")) {
                String s = c.collectDescendantText().trim();
                try {
                    Double valueDouble = NumberUtils.createDouble((String)s);
                    value = valueDouble.intValue();
                }
                catch (NumberFormatException ex) {
                    validationMessages.addErrorText(String.format("Cannot import value '%s' for field %s - Expected a numeric value instead", s, key));
                }
                continue;
            }
            if (!StringUtils.equals((String)node, (String)"txt")) continue;
            textValue = c.collectDescendantText().trim();
            textValue = "mn".equals(textValue) ? "min" : textValue;
        }
        return new Property(key, value, textValue);
    }

    @CheckForNull
    private static DebtModelXMLExporter.RuleDebt createRule(RuleKey ruleKey, Properties properties, ValidationMessages validationMessages) {
        String offset;
        Property function = properties.function();
        Property coefficientProperty = properties.coefficient();
        String coefficient = coefficientProperty == null ? null : coefficientProperty.toDuration();
        Property offsetProperty = properties.offset();
        String string = offset = offsetProperty == null ? null : offsetProperty.toDuration();
        if (function != null && (coefficient != null || offset != null)) {
            return DebtRulesXMLImporter.createRuleDebt(ruleKey, function.getTextValue(), coefficient, offset, validationMessages);
        }
        return null;
    }

    @CheckForNull
    private static DebtModelXMLExporter.RuleDebt createRuleDebt(RuleKey ruleKey, String function, @Nullable String coefficient, @Nullable String offset, ValidationMessages validationMessages) {
        if ("constant_resource".equals(function)) {
            validationMessages.addWarningText(String.format("Constant/file function is no longer used, technical debt definitions on '%s' are ignored.", ruleKey));
            return null;
        }
        if ("linear_threshold".equals(function) && coefficient != null) {
            validationMessages.addWarningText(String.format("Linear with threshold function is no longer used, remediation function of '%s' is replaced by linear.", ruleKey));
            return DebtRulesXMLImporter.createRuleDebt(ruleKey, DebtRemediationFunction.Type.LINEAR.name(), coefficient, null, validationMessages);
        }
        if (DebtRemediationFunction.Type.CONSTANT_ISSUE.name().equalsIgnoreCase(function) && coefficient != null && offset == null) {
            return DebtRulesXMLImporter.createRuleDebt(ruleKey, DebtRemediationFunction.Type.CONSTANT_ISSUE.name(), null, coefficient, validationMessages);
        }
        return new DebtModelXMLExporter.RuleDebt().setRuleKey(ruleKey).setFunction(function.toUpperCase()).setCoefficient(coefficient).setOffset(offset);
    }

    private static class PropertyMatchKey
    implements Predicate<Property> {
        private final String key;

        public PropertyMatchKey(String key) {
            this.key = key;
        }

        public boolean apply(@Nonnull Property input) {
            return input.getKey().equals(this.key);
        }
    }

    private static class Property {
        String key;
        int value;
        String textValue;

        private Property(String key, int value, String textValue) {
            this.key = key;
            this.value = value;
            this.textValue = textValue;
        }

        private String getKey() {
            return this.key;
        }

        private int getValue() {
            return this.value;
        }

        private String getTextValue() {
            return this.textValue;
        }

        @CheckForNull
        public String toDuration() {
            if (this.key != null && this.getValue() > 0) {
                String duration = Integer.toString(this.getValue());
                duration = duration + (!Strings.isNullOrEmpty((String)this.getTextValue()) ? this.getTextValue() : "d");
                return duration;
            }
            return null;
        }
    }

    private static class Properties {
        List<Property> list = Lists.newArrayList();

        public Properties add(Property property) {
            this.list.add(property);
            return this;
        }

        public Property function() {
            return this.find("remediationFunction");
        }

        public Property coefficient() {
            return this.find("remediationFactor");
        }

        public Property offset() {
            return this.find("offset");
        }

        private Property find(String key) {
            return (Property)Iterables.find(this.list, (Predicate)new PropertyMatchKey(key), null);
        }
    }
}

