/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.debt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ServerSide;
import org.xml.sax.InputSource;

@ServerSide
public class DebtModelXMLExporter {
    private static final String ROOT = "sqale";
    private static final String DEFAULT_INDENT = "2";
    public static final String CHARACTERISTIC = "chc";
    public static final String PROPERTY = "prop";
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_VALUE = "val";
    public static final String PROPERTY_TEXT_VALUE = "txt";
    public static final String REPOSITORY_KEY = "rule-repo";
    public static final String RULE_KEY = "rule-key";
    public static final String PROPERTY_FUNCTION = "remediationFunction";
    public static final String PROPERTY_COEFFICIENT = "remediationFactor";
    public static final String PROPERTY_OFFSET = "offset";

    protected String export(List<RuleDebt> allRules) {
        StringBuilder sb = new StringBuilder();
        sb.append("<sqale>");
        for (RuleDebt rule : allRules) {
            DebtModelXMLExporter.processRule(rule, sb);
        }
        sb.append("</sqale>");
        String xml = sb.toString();
        xml = DebtModelXMLExporter.prettyFormatXml(xml);
        return xml;
    }

    private static void processRule(RuleDebt rule, StringBuilder xml) {
        String[] values;
        xml.append("<chc>");
        xml.append("<rule-repo>");
        xml.append(StringEscapeUtils.escapeXml((String)rule.ruleKey().repository()));
        xml.append("</rule-repo><rule-key>");
        xml.append(StringEscapeUtils.escapeXml((String)rule.ruleKey().rule()));
        xml.append("</rule-key>");
        String coefficient = rule.coefficient();
        String offset = rule.offset();
        DebtModelXMLExporter.processProperty(PROPERTY_FUNCTION, null, rule.function(), xml);
        if (coefficient != null) {
            values = DebtModelXMLExporter.getValues(coefficient);
            DebtModelXMLExporter.processProperty(PROPERTY_COEFFICIENT, values[0], values[1], xml);
        }
        if (offset != null) {
            values = DebtModelXMLExporter.getValues(offset);
            DebtModelXMLExporter.processProperty(PROPERTY_OFFSET, values[0], values[1], xml);
        }
        xml.append("</chc>");
    }

    private static String[] getValues(String factorOrOffset) {
        String[] result = new String[2];
        Pattern pattern = Pattern.compile("(\\d+)(\\w+)");
        Matcher matcher = pattern.matcher(factorOrOffset);
        if (matcher.find()) {
            String value = matcher.group(1);
            String unit = matcher.group(2);
            result[0] = value;
            result[1] = unit;
        }
        return result;
    }

    private static void processProperty(String key, @Nullable String val, String text, StringBuilder xml) {
        xml.append("<prop><key>");
        xml.append(StringEscapeUtils.escapeXml((String)key));
        xml.append("</key>");
        if (val != null) {
            xml.append("<val>");
            xml.append(val);
            xml.append("</val>");
        }
        if (StringUtils.isNotEmpty((String)text)) {
            xml.append("<txt>");
            xml.append(StringEscapeUtils.escapeXml((String)text));
            xml.append("</txt>");
        }
        xml.append("</prop>");
    }

    private static String prettyFormatXml(String xml) {
        try {
            Transformer serializer = SAXTransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", DEFAULT_INDENT);
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray(), StandardCharsets.UTF_8);
        }
        catch (TransformerException transformerException) {
            return xml;
        }
    }

    public static class RuleDebt {
        private RuleKey ruleKey;
        private String function;
        private String coefficient;
        private String offset;

        public RuleKey ruleKey() {
            return this.ruleKey;
        }

        public RuleDebt setRuleKey(RuleKey ruleKey) {
            this.ruleKey = ruleKey;
            return this;
        }

        public String function() {
            return this.function;
        }

        public RuleDebt setFunction(String function) {
            this.function = function;
            return this;
        }

        @CheckForNull
        public String coefficient() {
            return this.coefficient;
        }

        public RuleDebt setCoefficient(@Nullable String coefficient) {
            this.coefficient = coefficient;
            return this;
        }

        @CheckForNull
        public String offset() {
            return this.offset;
        }

        public RuleDebt setOffset(@Nullable String offset) {
            this.offset = offset;
            return this;
        }

        public String toString() {
            return "RuleDebt{ruleKey=" + this.ruleKey + ", function=" + this.function + ", coefficient='" + this.coefficient + '\'' + ", offset='" + this.offset + '\'' + '}';
        }
    }
}

