/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.PathAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.duplication.Duplication;
import org.sonar.server.computation.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.server.computation.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.TextBlock;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.formula.FormulaExecutorComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.formula.counter.IntValue;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;
import org.sonar.server.computation.task.projectanalysis.measure.MeasureRepository;
import org.sonar.server.computation.task.projectanalysis.metric.MetricRepository;
import org.sonar.server.computation.task.projectanalysis.period.Period;
import org.sonar.server.computation.task.projectanalysis.period.PeriodHolder;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class NewSizeMeasuresStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final PeriodHolder periodHolder;
    private final MetricRepository metricRepository;
    private final MeasureRepository measureRepository;
    private final NewDuplicationFormula duplicationFormula;

    public NewSizeMeasuresStep(TreeRootHolder treeRootHolder, PeriodHolder periodHolder, MetricRepository metricRepository, MeasureRepository measureRepository, ScmInfoRepository scmInfoRepository, DuplicationRepository duplicationRepository) {
        this.treeRootHolder = treeRootHolder;
        this.periodHolder = periodHolder;
        this.metricRepository = metricRepository;
        this.measureRepository = measureRepository;
        this.duplicationFormula = new NewDuplicationFormula(scmInfoRepository, duplicationRepository);
    }

    @Override
    public String getDescription() {
        return "Compute size measures on new code";
    }

    @Override
    public void execute() {
        new PathAwareCrawler<FormulaExecutorComponentVisitor.Counters>(FormulaExecutorComponentVisitor.newBuilder(this.metricRepository, this.measureRepository).withVariationSupport(this.periodHolder).buildFor((Iterable<Formula>)ImmutableList.of((Object)this.duplicationFormula))).visit(this.treeRootHolder.getRoot());
    }

    private static final class NewDuplicationFormula
    implements Formula<NewSizeCounter> {
        private final DuplicationRepository duplicationRepository;
        private final ScmInfoRepository scmInfoRepository;

        private NewDuplicationFormula(ScmInfoRepository scmInfoRepository, DuplicationRepository duplicationRepository) {
            this.duplicationRepository = duplicationRepository;
            this.scmInfoRepository = scmInfoRepository;
        }

        @Override
        public NewSizeCounter createNewCounter() {
            return new NewSizeCounter(this.duplicationRepository, this.scmInfoRepository);
        }

        @Override
        public com.google.common.base.Optional<Measure> createMeasure(NewSizeCounter counter, CreateMeasureContext context) {
            String metricKey;
            switch (metricKey = context.getMetric().getKey()) {
                case "new_lines": {
                    return NewDuplicationFormula.createMeasure(counter.newLines);
                }
                case "new_duplicated_lines": {
                    return NewDuplicationFormula.createMeasure(counter.newDuplicatedLines);
                }
                case "new_duplicated_lines_density": {
                    return NewDuplicationFormula.createNewDuplicatedLinesDensityMeasure(counter);
                }
                case "new_duplicated_blocks": {
                    return NewDuplicationFormula.createMeasure(counter.newDuplicatedBlocks);
                }
            }
            throw new IllegalArgumentException("Unsupported metric " + context.getMetric());
        }

        private static com.google.common.base.Optional<Measure> createMeasure(IntValue intValue) {
            return intValue.isSet() ? com.google.common.base.Optional.of((Object)Measure.newMeasureBuilder().setVariation(intValue.getValue()).createNoValue()) : com.google.common.base.Optional.absent();
        }

        private static com.google.common.base.Optional<Measure> createNewDuplicatedLinesDensityMeasure(NewSizeCounter counter) {
            IntValue newLines = counter.newLines;
            IntValue newDuplicatedLines = counter.newDuplicatedLines;
            if (newLines.isSet() && newDuplicatedLines.isSet()) {
                int newLinesVariations = newLines.getValue();
                int newDuplicatedLinesVariations = newDuplicatedLines.getValue();
                if ((double)newLinesVariations > 0.0) {
                    double density = Math.min(100.0, 100.0 * (double)newDuplicatedLinesVariations / (double)newLinesVariations);
                    return com.google.common.base.Optional.of((Object)Measure.newMeasureBuilder().setVariation(density).createNoValue());
                }
            }
            return com.google.common.base.Optional.absent();
        }

        @Override
        public String[] getOutputMetricKeys() {
            return new String[]{"new_lines", "new_duplicated_lines", "new_duplicated_lines_density", "new_duplicated_blocks"};
        }
    }

    private static class DuplicationCounters {
        private final ScmInfo scmInfo;
        private final Period period;
        private final Set<Integer> lineCounts;
        private int blockCounts;

        private DuplicationCounters(ScmInfo scmInfo, Period period, int changesetSize) {
            this.scmInfo = scmInfo;
            this.period = period;
            this.lineCounts = new HashSet<Integer>(changesetSize);
        }

        void addBlock(TextBlock textBlock) {
            Boolean[] newBlock = new Boolean[]{false};
            IntStream.rangeClosed(textBlock.getStart(), textBlock.getEnd()).filter(this.scmInfo::hasChangesetForLine).filter(line -> this.isLineInPeriod(line, this.period)).forEach(line -> {
                this.lineCounts.add(line);
                newBlock[0] = true;
            });
            if (newBlock[0].booleanValue()) {
                ++this.blockCounts;
            }
        }

        int getNewLinesDuplicated() {
            return this.lineCounts.size();
        }

        int getNewBlocksDuplicated() {
            return this.blockCounts;
        }

        private boolean isLineInPeriod(int lineNumber, Period period) {
            return this.scmInfo.getChangesetForLine(lineNumber).getDate() > period.getSnapshotDate();
        }
    }

    private static class NewSizeCounter
    implements Counter<NewSizeCounter> {
        private final DuplicationRepository duplicationRepository;
        private final ScmInfoRepository scmInfoRepository;
        private final IntValue newLines = new IntValue();
        private final IntValue newDuplicatedLines = new IntValue();
        private final IntValue newDuplicatedBlocks = new IntValue();

        private NewSizeCounter(DuplicationRepository duplicationRepository, ScmInfoRepository scmInfoRepository) {
            this.duplicationRepository = duplicationRepository;
            this.scmInfoRepository = scmInfoRepository;
        }

        @Override
        public void aggregate(NewSizeCounter counter) {
            this.newDuplicatedLines.increment(counter.newDuplicatedLines);
            this.newDuplicatedBlocks.increment(counter.newDuplicatedBlocks);
            this.newLines.increment(counter.newLines);
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            Component leaf = context.getLeaf();
            Optional<ScmInfo> scmInfo = this.scmInfoRepository.getScmInfo(leaf);
            if (!scmInfo.isPresent() || !context.hasPeriod()) {
                return;
            }
            this.newLines.increment(0);
            if (leaf.getType() != Component.Type.FILE) {
                this.newDuplicatedLines.increment(0);
                this.newDuplicatedBlocks.increment(0);
                return;
            }
            this.initNewLines(scmInfo.get(), context.getPeriod());
            this.initNewDuplicated(leaf, scmInfo.get(), context.getPeriod());
        }

        private void initNewLines(ScmInfo scmInfo, Period period) {
            scmInfo.getAllChangesets().values().stream().filter(changeset -> NewSizeCounter.isLineInPeriod(changeset, period)).forEach(changeset -> this.newLines.increment(1));
        }

        private void initNewDuplicated(Component component, ScmInfo scmInfo, Period period) {
            DuplicationCounters duplicationCounters = new DuplicationCounters(scmInfo, period, scmInfo.getAllChangesets().size());
            Iterable<Duplication> duplications = this.duplicationRepository.getDuplications(component);
            for (Duplication duplication : duplications) {
                duplicationCounters.addBlock(duplication.getOriginal());
                duplication.getDuplicates().stream().filter(InnerDuplicate.class::isInstance).map(duplicate -> (InnerDuplicate)duplicate).forEach(duplicate -> duplicationCounters.addBlock(duplicate.getTextBlock()));
            }
            this.newDuplicatedLines.increment(duplicationCounters.getNewLinesDuplicated());
            this.newDuplicatedBlocks.increment(duplicationCounters.getNewBlocksDuplicated());
        }

        private static boolean isLineInPeriod(Changeset changeset, Period period) {
            return changeset.getDate() > period.getSnapshotDate();
        }
    }
}

