/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.step;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import javax.annotation.Nonnull;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.server.computation.task.projectanalysis.batch.BatchReportReader;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.duplication.DetailedTextBlock;
import org.sonar.server.computation.task.projectanalysis.duplication.Duplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.Duplication;
import org.sonar.server.computation.task.projectanalysis.duplication.DuplicationRepository;
import org.sonar.server.computation.task.projectanalysis.duplication.InProjectDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.InnerDuplicate;
import org.sonar.server.computation.task.projectanalysis.duplication.TextBlock;
import org.sonar.server.computation.task.step.ComputationStep;

public class LoadDuplicationsFromReportStep
implements ComputationStep {
    private final TreeRootHolder treeRootHolder;
    private final BatchReportReader batchReportReader;
    private final DuplicationRepository duplicationRepository;

    public LoadDuplicationsFromReportStep(TreeRootHolder treeRootHolder, BatchReportReader batchReportReader, DuplicationRepository duplicationRepository) {
        this.treeRootHolder = treeRootHolder;
        this.batchReportReader = batchReportReader;
        this.duplicationRepository = duplicationRepository;
    }

    @Override
    public String getDescription() {
        return "Load inner file and in project duplications";
    }

    @Override
    public void execute() {
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitFile(Component file) {
                try (CloseableIterator<ScannerReport.Duplication> duplications = LoadDuplicationsFromReportStep.this.batchReportReader.readComponentDuplications(file.getReportAttributes().getRef());){
                    int idGenerator = 1;
                    while (duplications.hasNext()) {
                        LoadDuplicationsFromReportStep.this.loadDuplications(file, (ScannerReport.Duplication)duplications.next(), idGenerator);
                        ++idGenerator;
                    }
                }
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    private void loadDuplications(Component file, ScannerReport.Duplication duplication, int id) {
        this.duplicationRepository.add(file, new Duplication(LoadDuplicationsFromReportStep.convert(duplication.getOriginPosition(), id), (Iterable<Duplicate>)FluentIterable.from((Iterable)duplication.getDuplicateList()).transform((Function)new BatchDuplicateToCeDuplicate(file))));
    }

    private static TextBlock convert(ScannerReport.TextRange textRange) {
        return new TextBlock(textRange.getStartLine(), textRange.getEndLine());
    }

    private static DetailedTextBlock convert(ScannerReport.TextRange textRange, int id) {
        return new DetailedTextBlock(id, textRange.getStartLine(), textRange.getEndLine());
    }

    private class BatchDuplicateToCeDuplicate
    implements Function<ScannerReport.Duplicate, Duplicate> {
        private final Component file;

        private BatchDuplicateToCeDuplicate(Component file) {
            this.file = file;
        }

        @Nonnull
        public Duplicate apply(@Nonnull ScannerReport.Duplicate input) {
            if (input.getOtherFileRef() != 0) {
                Preconditions.checkArgument((input.getOtherFileRef() != this.file.getReportAttributes().getRef() ? 1 : 0) != 0, (Object)"file and otherFile references can not be the same");
                return new InProjectDuplicate(LoadDuplicationsFromReportStep.this.treeRootHolder.getComponentByRef(input.getOtherFileRef()), LoadDuplicationsFromReportStep.convert(input.getRange()));
            }
            return new InnerDuplicate(LoadDuplicationsFromReportStep.convert(input.getRange()));
        }
    }
}

