/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoImpl;

public class GeneratedScmInfo
implements ScmInfo {
    private final ScmInfoImpl delegate;

    public GeneratedScmInfo(Map<Integer, Changeset> changesets) {
        this.delegate = new ScmInfoImpl(changesets);
    }

    public static ScmInfo create(long analysisDate, Set<Integer> lines) {
        Preconditions.checkState((!lines.isEmpty() ? 1 : 0) != 0, (Object)"No changesets");
        Changeset changeset = Changeset.newChangesetBuilder().setDate(analysisDate).build();
        Map<Integer, Changeset> changesets = lines.stream().collect(Collectors.toMap(x -> x, i -> changeset));
        return new GeneratedScmInfo(changesets);
    }

    public static ScmInfo create(long analysisDate, int[] matches, ScmInfo dbScmInfo) {
        Changeset changeset = Changeset.newChangesetBuilder().setDate(analysisDate).build();
        Map<Integer, Changeset> dbChangesets = dbScmInfo.getAllChangesets();
        LinkedHashMap<Integer, Changeset> changesets = new LinkedHashMap<Integer, Changeset>(matches.length);
        for (int i = 0; i < matches.length; ++i) {
            if (matches[i] > 0) {
                changesets.put(i + 1, dbChangesets.get(matches[i]));
                continue;
            }
            changesets.put(i + 1, changeset);
        }
        return new GeneratedScmInfo(changesets);
    }

    @Override
    public Changeset getLatestChangeset() {
        return this.delegate.getLatestChangeset();
    }

    @Override
    public Changeset getChangesetForLine(int lineNumber) {
        return this.delegate.getChangesetForLine(lineNumber);
    }

    @Override
    public boolean hasChangesetForLine(int lineNumber) {
        return this.delegate.hasChangesetForLine(lineNumber);
    }

    @Override
    public Map<Integer, Changeset> getAllChangesets() {
        return this.delegate.getAllChangesets();
    }
}

