/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.scm;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.computation.task.projectanalysis.scm.Changeset;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfo;
import org.sonar.server.computation.task.projectanalysis.scm.ScmInfoImpl;

@Immutable
class DbScmInfo
implements ScmInfo {
    private final ScmInfo delegate;
    private final String fileHash;

    private DbScmInfo(ScmInfo delegate, String fileHash) {
        this.delegate = delegate;
        this.fileHash = fileHash;
    }

    public static Optional<DbScmInfo> create(Iterable<DbFileSources.Line> lines, String fileHash) {
        LineToChangeset lineToChangeset = new LineToChangeset();
        LinkedHashMap<Integer, Changeset> lineChanges = new LinkedHashMap<Integer, Changeset>();
        for (DbFileSources.Line line : lines) {
            Changeset changeset = lineToChangeset.apply(line);
            if (changeset == null) continue;
            lineChanges.put(line.getLine(), changeset);
        }
        if (lineChanges.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DbScmInfo(new ScmInfoImpl(lineChanges), fileHash));
    }

    public String fileHash() {
        return this.fileHash;
    }

    @Override
    public Changeset getLatestChangeset() {
        return this.delegate.getLatestChangeset();
    }

    @Override
    public Changeset getChangesetForLine(int lineNumber) {
        return this.delegate.getChangesetForLine(lineNumber);
    }

    @Override
    public boolean hasChangesetForLine(int lineNumber) {
        return this.delegate.hasChangesetForLine(lineNumber);
    }

    @Override
    public Map<Integer, Changeset> getAllChangesets() {
        return this.delegate.getAllChangesets();
    }

    private static class LineToChangeset
    implements Function<DbFileSources.Line, Changeset> {
        private final Changeset.Builder builder = Changeset.newChangesetBuilder();
        private final HashMap<Changeset, Changeset> cache = new HashMap();

        private LineToChangeset() {
        }

        @Override
        @Nullable
        public Changeset apply(@Nonnull DbFileSources.Line input) {
            if (input.hasScmDate()) {
                Changeset cs = this.builder.setRevision(input.hasScmRevision() ? input.getScmRevision() : null).setAuthor(input.hasScmAuthor() ? input.getScmAuthor() : null).setDate(input.getScmDate()).build();
                if (this.cache.containsKey(cs)) {
                    return this.cache.get(cs);
                }
                this.cache.put(cs, cs);
                return cs;
            }
            return null;
        }
    }
}

