/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.qualitygate;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConditionStatus {
    public static final ConditionStatus NO_VALUE_STATUS = new ConditionStatus(EvaluationStatus.NO_VALUE, null);
    private final EvaluationStatus status;
    @CheckForNull
    private final String value;

    private ConditionStatus(EvaluationStatus status, @Nullable String value) {
        this.status = Objects.requireNonNull(status, "status can not be null");
        this.value = value;
    }

    public static ConditionStatus create(EvaluationStatus status, String value) {
        Objects.requireNonNull(status, "status can not be null");
        Preconditions.checkArgument((status != EvaluationStatus.NO_VALUE ? 1 : 0) != 0, (Object)"EvaluationStatus 'NO_VALUE' can not be used with this method, use constant ConditionStatus.NO_VALUE_STATUS instead.");
        Objects.requireNonNull(value, "value can not be null");
        return new ConditionStatus(status, value);
    }

    public EvaluationStatus getStatus() {
        return this.status;
    }

    @CheckForNull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "ConditionStatus{status=" + (Object)((Object)this.status) + ", value='" + this.value + '\'' + '}';
    }

    public static enum EvaluationStatus {
        NO_VALUE,
        OK,
        WARN,
        ERROR;

    }
}

