/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.period;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Period {
    private final String mode;
    @CheckForNull
    private final String modeParameter;
    private final long snapshotDate;
    private final String analysisUuid;

    public Period(String mode, @Nullable String modeParameter, long snapshotDate, String analysisUuid) {
        this.mode = Objects.requireNonNull(mode);
        this.modeParameter = modeParameter;
        this.snapshotDate = snapshotDate;
        this.analysisUuid = analysisUuid;
    }

    public String getMode() {
        return this.mode;
    }

    @CheckForNull
    public String getModeParameter() {
        return this.modeParameter;
    }

    public long getSnapshotDate() {
        return this.snapshotDate;
    }

    public String getAnalysisUuid() {
        return this.analysisUuid;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Period period = (Period)o;
        return this.snapshotDate == period.snapshotDate && Objects.equals(this.analysisUuid, period.analysisUuid) && this.mode.equals(period.mode) && Objects.equals(this.modeParameter, period.modeParameter);
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.modeParameter, this.snapshotDate, this.analysisUuid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).add("modeParameter", (Object)this.modeParameter).add("snapshotDate", this.snapshotDate).add("analysisUuid", (Object)this.analysisUuid).toString();
    }
}

